/*
Copyright 2015 Alexander Bunkenburg <alex@inspiracio.cat>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package cat.inspiracio.html;

import java.io.IOException;
import java.io.InputStream;

import nu.validator.htmlparser.dom.HtmlDocumentBuilder;

import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/** Builds html5 documents. */
public class HTMLDocumentBuilder extends HtmlDocumentBuilder{

	public HTMLDocumentBuilder(){
		super(new HTMLDOMImplementation());
	}

	public HTMLDocumentBuilder(DOMImplementation implementation){
		super(implementation);
	}
	
	// business methods -------------------------
	
	@Override public HTMLDocument newDocument(){
		Document d=super.newDocument();
		return (HTMLDocument)d;
	}
	
	@Override public HTMLDocument parse(InputStream in) throws SAXException, IOException{
		Document d=super.parse(in);
		return (HTMLDocument)d;
	}

	@Override public HTMLDocument parse(InputSource in) throws SAXException, IOException{
		Document d=super.parse(in);
		return (HTMLDocument)d;
	}
}
