/*
Copyright 2015 Alexander Bunkenburg <alex@inspiracio.cat>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package cat.inspiracio.html;

class HTMLParamElementImp extends HTMLElementImp implements HTMLParamElement {
	private static final long serialVersionUID = 5578307094865876737L;

	HTMLParamElementImp(HTMLDocumentImp owner){super(owner, "param");}

	@Override public HTMLParamElement cloneNode(boolean deep){
		return (HTMLParamElement)super.cloneNode(deep);
	}
	
	// methods ----------------------------------------------

	@Override public String getName(){return getAttribute("name");}
	@Override public void setName(String name){setAttribute("name", name);}

	@Override public String getValue(){return getAttribute("value");}
	@Override public void setValue(String value){setAttribute("value", value);}
}
