/*
Copyright 2015 Alexander Bunkenburg <alex@inspiracio.cat>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package cat.inspiracio.html;

class HTMLTableColElementImp extends HTMLElementImp implements HTMLTableColElement {
	private static final long serialVersionUID = -7111351996766408700L;

	/** @param tag "col" or "colgroup" */
	HTMLTableColElementImp(HTMLDocumentImp owner, String tag){super(owner, tag);}

	@Override public HTMLTableColElement cloneNode(boolean deep){
		return (HTMLTableColElement)super.cloneNode(deep);
	}
	
	// methods ----------------------------------------------

	@Override public int getSpan(){return getAttributeInt("span");}
	@Override public void setSpan(int span){setAttribute("span", span);}

}
