/*
Copyright 2015 Alexander Bunkenburg <alex@inspiracio.cat>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package cat.inspiracio.lang;

/** This exception means that a method is correct for an interface
 * or class, but that I have not implemented it yet.
 * 
 * See method comments and file todo.md to find out more
 * about the method.
 * */
public class NotImplementedException extends RuntimeException {
	private static final long serialVersionUID = -4085472433451913646L;

	public NotImplementedException(){}

	public NotImplementedException(String message){super(message);}

	public NotImplementedException(Object message){super("" + message);}
}
