/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.dom;

import cat.inspiracio.dom.DOMTokenList;
import cat.inspiracio.dom.InvalidCharacterError;
import cat.inspiracio.dom.SyntaxError;
import cat.inspiracio.html.HTMLElement;
import java.util.ArrayList;
import java.util.List;

public class DOMTokenListImp
implements DOMTokenList {
    private static final long serialVersionUID = -6284575687653982416L;
    private List<String> tokens = new ArrayList<String>();
    private HTMLElement element;
    private String key;

    public DOMTokenListImp(HTMLElement element, String key) {
        this.element = element;
        this.key = key;
        String value = element.getAttribute(key);
        this.setValue(value);
    }

    protected void setValue(String value) {
        this.tokens.clear();
        if (0 < value.length()) {
            String[] ts = value.split("\\s+");
            for (int i = 0; i < ts.length; ++i) {
                this.tokens.add(ts[i]);
            }
        }
    }

    @Override
    public int getLength() {
        return this.tokens.size();
    }

    @Override
    public String item(int index) {
        return this.tokens.get(index);
    }

    @Override
    public boolean contains(String token) {
        this.check(token);
        return this.tokens.contains(token);
    }

    @Override
    public void add(String ... tokens) {
        for (String token : tokens) {
            this.check(token);
        }
        for (String token : tokens) {
            if (this.tokens.contains(token)) continue;
            this.tokens.add(token);
        }
        this.update();
    }

    @Override
    public void remove(String ... tokens) {
        for (String token : tokens) {
            this.check(token);
        }
        for (String token : tokens) {
            this.tokens.remove(token);
        }
        this.update();
    }

    @Override
    public boolean toggle(String token) {
        if (this.contains(token)) {
            this.remove(token);
            return false;
        }
        this.add(token);
        return true;
    }

    @Override
    public boolean toggle(String token, boolean force) {
        if (force) {
            this.add(token);
        } else {
            this.remove(token);
        }
        return force;
    }

    protected String getValue() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String token : this.tokens) {
            if (!first) {
                builder.append(' ');
            }
            first = false;
            builder.append(token);
        }
        return builder.toString();
    }

    private void update() {
        if (this.element == null || this.key == null) {
            return;
        }
        String value = this.getValue();
        this.element.setAttribute(this.key, value);
    }

    public String toString() {
        return this.getValue();
    }

    private boolean containsWhite(String s) {
        return s.matches(".*\\s+.*");
    }

    private void check(String token) {
        if (token == null || 0 == token.length()) {
            throw new SyntaxError();
        }
        if (this.containsWhite(token)) {
            throw new InvalidCharacterError();
        }
    }
}

