/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.dom;

import cat.inspiracio.dom.HTMLCollection;
import cat.inspiracio.html.HTMLElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HTMLCollectionImp<T extends HTMLElement>
implements HTMLCollection<T> {
    private static final long serialVersionUID = -7738853951098271927L;
    protected List<T> elements = new ArrayList<T>();

    public HTMLCollectionImp() {
    }

    public HTMLCollectionImp(HTMLElement element, Filter f) {
        if (element == null) {
            return;
        }
        HTMLCollection<HTMLElement> children = element.getChildElements();
        for (int i = 0; i < children.getLength(); ++i) {
            HTMLElement e = children.item(i);
            this.addAll(f, e);
        }
    }

    private void addAll(Filter f, HTMLElement element) {
        if (f.accept(element)) {
            this.add(element);
        }
        HTMLCollection<HTMLElement> children = element.getChildElements();
        for (int i = 0; i < children.getLength(); ++i) {
            HTMLElement e = children.item(i);
            this.addAll(f, e);
        }
    }

    public void add(T e) {
        this.elements.add(e);
    }

    @Override
    public int getLength() {
        return this.elements.size();
    }

    @Override
    public T item(int index) {
        if (index < 0 || this.elements.size() <= index) {
            return null;
        }
        return (T)((HTMLElement)this.elements.get(index));
    }

    @Override
    public T namedItem(String name) {
        if (name == null || 0 == name.length()) {
            return null;
        }
        for (HTMLElement e : this.elements) {
            if (!name.equals(e.getName())) continue;
            return (T)e;
        }
        return null;
    }

    public String toString() {
        return this.elements.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    public static interface Filter {
        public boolean accept(HTMLElement var1);
    }
}

