/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.DOMStringMap;
import cat.inspiracio.dom.SyntaxError;
import java.io.Serializable;
import org.w3c.dom.Element;

class DatasetImp
implements DOMStringMap,
Serializable {
    private static final long serialVersionUID = -372701818121063698L;
    private Element element;

    DatasetImp(Element e) {
        this.element = e;
    }

    @Override
    public boolean has(String name) {
        String key = this.toKey(name);
        return this.element.hasAttribute(key);
    }

    @Override
    public String get(String name) {
        String key = this.toKey(name);
        return this.element.getAttribute(key);
    }

    @Override
    public void set(String name, String value) {
        String key = this.toKey(name);
        this.element.setAttribute(key, value);
    }

    @Override
    public void set(String name, int i) {
        String key = this.toKey(name);
        String value = Integer.toString(i);
        this.element.setAttribute(key, value);
    }

    @Override
    public void deleter(String name) {
        String key = this.toKey(name);
        this.element.removeAttribute(key);
    }

    private boolean containsUppercase(String key) {
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    private String toKey(Object object) {
        String name = object.toString();
        if (name.contains("-")) {
            throw new SyntaxError(name);
        }
        StringBuilder builder = new StringBuilder("data-");
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                builder.append('-');
                char lower = Character.toLowerCase(c);
                builder.append(lower);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private boolean isKey(String key) {
        return key.startsWith("data-");
    }

    private String toName(String key) {
        if (!this.isKey(key)) {
            return null;
        }
        StringBuilder builder = new StringBuilder(key);
        int dash = key.indexOf(45);
        while (-1 < dash) {
            char next;
            int length = builder.length();
            if (dash + 1 < length && Character.isLowerCase(next = builder.charAt(dash + 1))) {
                String replace = Character.toUpperCase(next) + "";
                builder.replace(dash, dash + 2, replace);
            }
            dash = key.indexOf(45);
        }
        return builder.toString();
    }
}

