/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentRecurser<T> {
    public T document(Document d) throws Exception {
        this.open(d);
        this.doctype(d.getDoctype());
        this.documentURI(d.getDocumentURI());
        Element e = d.getDocumentElement();
        if (e != null) {
            this.element(e);
        }
        return this.close(d);
    }

    protected DocumentRecurser<T> element(Element e) throws Exception {
        this.open(e);
        this.nodes(e.getChildNodes());
        return this.close(e);
    }

    protected DocumentRecurser<T> attributes(Element e) throws Exception {
        NamedNodeMap as = e.getAttributes();
        for (int i = 0; i < as.getLength(); ++i) {
            Attr a = (Attr)as.item(i);
            this.attribute(a);
        }
        return this;
    }

    protected DocumentRecurser<T> attribute(Attr a) throws Exception {
        String key = a.getName();
        String value = a.getValue();
        return this.attribute(key, value);
    }

    protected DocumentRecurser<T> text(Text t) throws Exception {
        String s = t.getData();
        return this.text(s);
    }

    protected DocumentRecurser<T> comment(Comment c) throws Exception {
        String s = c.getData();
        return this.comment(s);
    }

    protected DocumentRecurser<T> cdata(CDATASection cd) throws Exception {
        String s = cd.getData();
        return this.cdata(s);
    }

    protected DocumentRecurser<T> nodes(NodeList ns) throws Exception {
        for (int i = 0; i < ns.getLength(); ++i) {
            Node n = ns.item(i);
            this.node(n);
        }
        return this;
    }

    protected DocumentRecurser<T> node(Node n) throws Exception {
        short type = n.getNodeType();
        switch (type) {
            case 2: {
                this.attribute((Attr)n);
                break;
            }
            case 4: {
                this.cdata((CDATASection)n);
                break;
            }
            case 8: {
                this.comment((Comment)n);
                break;
            }
            case 11: {
                this.fragment((DocumentFragment)n);
                break;
            }
            case 9: {
                this.document((Document)n);
                break;
            }
            case 10: {
                this.doctype((DocumentType)n);
                break;
            }
            case 1: {
                this.element((Element)n);
                break;
            }
            case 6: {
                this.entity((Entity)n);
                break;
            }
            case 5: {
                this.entityReference((EntityReference)n);
                break;
            }
            case 12: {
                this.notation((Notation)n);
                break;
            }
            case 7: {
                this.processingInstruction((ProcessingInstruction)n);
                break;
            }
            case 3: {
                this.text((Text)n);
            }
        }
        return this;
    }

    protected DocumentRecurser<T> open(Document d) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> doctype(DocumentType type) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> documentURI(String uri) throws Exception {
        return this;
    }

    protected T close(Document d) throws Exception {
        return null;
    }

    protected DocumentRecurser<T> open(Element e) throws Exception {
        return this.attributes(e);
    }

    protected DocumentRecurser<T> close(Element e) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> attribute(String key, String value) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> text(String s) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> cdata(String s) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> comment(String s) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> entity(Entity e) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> entityReference(EntityReference er) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> notation(Notation n) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> processingInstruction(ProcessingInstruction i) throws Exception {
        return this;
    }

    protected DocumentRecurser<T> fragment(DocumentFragment f) throws Exception {
        return this.nodes(f.getChildNodes());
    }
}

