/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.html.DocumentRecurser;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class DocumentWriter
extends DocumentRecurser<Void> {
    private static final String NL = "\n";
    private Writer w;

    public DocumentWriter(Writer writer) {
        this.w = writer;
    }

    protected DocumentWriter write(char c) throws IOException {
        this.w.write(c);
        return this;
    }

    public DocumentWriter write(String s) throws IOException {
        this.w.write(s);
        return this;
    }

    public DocumentWriter writeln(String s) throws IOException {
        this.w.write(s);
        this.writeln();
        return this;
    }

    public DocumentWriter writeln(char c) throws IOException {
        this.w.write(c);
        this.writeln();
        return this;
    }

    protected DocumentWriter writeln() throws IOException {
        this.w.write(NL);
        return this;
    }

    protected DocumentWriter doctype(DocumentType type) throws IOException {
        return this.writeln("<!DOCTYPE html>");
    }

    protected DocumentWriter element(Element e) throws Exception {
        String tag = e.getTagName();
        if ("script".equals(tag)) {
            this.script(e);
        } else {
            super.element(e);
        }
        return this;
    }

    protected void script(Element element) throws Exception {
        this.open(element);
        String s = element.getTextContent();
        this.write(s);
        this.close(element);
    }

    protected DocumentWriter open(Element e) throws Exception {
        String tag = e.getTagName();
        boolean b = e.hasChildNodes() || this.needClosingTag(tag);
        this.write("<");
        this.write(tag);
        this.attributes(e);
        if (b) {
            this.write(">");
        }
        return this;
    }

    protected DocumentWriter attribute(String key, String value) throws Exception {
        this.write(" ");
        this.write(key);
        if (value != null && 0 < value.length()) {
            this.write("=");
            value = this.quote(value);
            this.write(value);
        }
        return this;
    }

    protected DocumentWriter text(String s) throws Exception {
        return this.writeEscapeElement(s);
    }

    protected DocumentWriter close(Element e) throws IOException {
        boolean b;
        String tag = e.getTagName();
        boolean bl = b = e.hasChildNodes() || this.needClosingTag(tag);
        if (b) {
            this.write("</");
            this.write(tag);
            this.write(">");
        } else {
            this.write("/>");
        }
        return this;
    }

    protected DocumentWriter cdata(String s) throws Exception {
        s = this.escapeCData(s);
        this.write("<![CDATA[");
        this.write(s);
        this.write("]]>");
        return this;
    }

    private String escapeCData(String s) {
        if (s == null) {
            return s;
        }
        if (!s.contains("]]>")) {
            return s;
        }
        return s.replaceAll("]]>", "]]]]><![CDATA[>");
    }

    protected DocumentWriter comment(String s) throws Exception {
        s = this.escapeComment(s);
        this.write("<!--");
        this.write(s);
        return this.write("-->");
    }

    private String escapeComment(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith(">") || s.startsWith("->") || s.endsWith("-")) {
            s = "[" + s + "]";
        }
        if (!s.contains("--")) {
            return s;
        }
        String replacement = "--&gt;";
        replacement = "[escaped double -]";
        String t = s.replaceAll("--", replacement);
        return t;
    }

    protected DocumentWriter writeEscapeElement(String s) throws IOException {
        if (s.indexOf(38) == -1 && s.indexOf(60) == -1 && s.indexOf(62) == -1) {
            return this.write(s);
        }
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    this.write("&amp;");
                    continue block4;
                }
                case '<': {
                    this.write("&lt;");
                    continue block4;
                }
                default: {
                    this.write(c);
                }
            }
        }
        return this;
    }

    protected boolean needClosingTag(String tag) {
        switch (tag) {
            case "a": {
                return true;
            }
            case "script": {
                return true;
            }
            case "textarea": {
                return true;
            }
            case "title": {
                return true;
            }
        }
        return false;
    }

    protected String quote(String value) {
        if (this.contains(value, '\"')) {
            value = value.replaceAll("\"", "&quot;");
        }
        return '\"' + value + '\"';
    }

    private boolean contains(String value, char c) {
        return 0 <= value.indexOf(c);
    }

    public String toString() {
        return this.w.toString();
    }
}

