/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.DOMStringMap;
import cat.inspiracio.dom.HTMLCollection;
import cat.inspiracio.dom.HTMLCollectionImp;
import cat.inspiracio.html.DatasetImp;
import cat.inspiracio.html.DocumentRecurser;
import cat.inspiracio.html.DocumentWriter;
import cat.inspiracio.html.HTMLDocument;
import cat.inspiracio.html.HTMLDocumentImp;
import cat.inspiracio.html.HTMLElement;
import cat.inspiracio.html.HTMLFormElement;
import cat.inspiracio.html.HTMLHtmlElement;
import cat.inspiracio.lang.NotImplementedException;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HTMLElementImp
extends ElementImpl
implements HTMLElement {
    private static final long serialVersionUID = -7630166106874010622L;

    protected HTMLElementImp(HTMLDocumentImp owner, String tag) {
        super((CoreDocumentImpl)owner, tag.toLowerCase());
    }

    @Override
    public HTMLElement cloneNode(boolean deep) {
        return (HTMLElement)super.cloneNode(deep);
    }

    private boolean descendsFrom(HTMLElement ancestor) {
        if (ancestor == null) {
            return false;
        }
        if (ancestor == this) {
            return false;
        }
        for (Node parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        newChild = this.adoptNode(newChild);
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return super.appendChild(newChild);
    }

    private Node adoptNode(Node newChild) {
        HTMLDocument document = this.getOwnerDocument();
        return document.adoptNode(newChild);
    }

    @Override
    public NodeList getChildNodes() {
        return this.getChildNodesUnoptimized();
    }

    @Override
    public HTMLCollection<HTMLElement> getChildElements() {
        HTMLCollectionImp<HTMLElement> elements = new HTMLCollectionImp<HTMLElement>();
        NodeList children = this.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!(child instanceof HTMLElement)) continue;
            HTMLElement e = (HTMLElement)child;
            elements.add(e);
        }
        return elements;
    }

    protected void remove() {
        Node parent = this.getParentNode();
        if (parent != null) {
            parent.removeChild(this);
        }
    }

    protected HTMLElement getElementById(String id) {
        return this.getOwnerDocument().getElementById(id);
    }

    @Override
    public String getStyle() {
        return this.getAttribute("style");
    }

    @Override
    public void setStyle(String style) {
        this.setAttribute("style", style);
    }

    protected HTMLFormElement getForm() {
        for (Node parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof HTMLFormElement)) continue;
            return (HTMLFormElement)parent;
        }
        return null;
    }

    protected String getText() {
        StringBuilder text = new StringBuilder();
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Text)) continue;
            Text t = (Text)child;
            String data = t.getData();
            text.append(data);
        }
        return text.toString();
    }

    @Override
    public void prepend(HTMLElement element) {
        Node first = this.getFirstChild();
        this.insertBefore(element, first);
    }

    @Override
    public String getId() {
        return this.getAttribute("id");
    }

    @Override
    public void setId(String id) {
        this.setAttribute("id", id);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public void setName(String n) {
        this.setAttribute("name", n);
    }

    @Override
    public String getTitle() {
        return this.getAttribute("title");
    }

    @Override
    public void setTitle(String title) {
        this.setAttribute("title", title);
    }

    @Override
    public String getLang() {
        return this.getAttribute("lang");
    }

    @Override
    public void setLang(String lang) {
        this.setAttribute("lang", lang);
    }

    @Override
    public HTMLDocument getOwnerDocument() {
        return (HTMLDocument)super.getOwnerDocument();
    }

    protected boolean isInDocument() {
        HTMLDocument document = this.getOwnerDocument();
        if (document == null) {
            return false;
        }
        HTMLHtmlElement html = document.getDocumentElement();
        if (html == null) {
            return false;
        }
        boolean descends = this.descendsFrom(html);
        return descends;
    }

    @Override
    public String getDir() {
        return this.getAttribute("dir");
    }

    @Override
    public void setDir(String dir) {
        this.setAttribute("dir", dir);
    }

    @Override
    public String getClassName() {
        return this.getAttribute("class");
    }

    @Override
    public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    @Override
    public boolean getTranslate() {
        throw new NotImplementedException();
    }

    @Override
    public void setTranslate(boolean t) {
        this.setAttribute("translate", this.yesNo(t));
    }

    @Override
    public DOMStringMap getDataset() {
        return new DatasetImp(this);
    }

    @Override
    public boolean getHidden() {
        return this.getAttributeBoolean("hidden");
    }

    @Override
    public void setHidden(boolean h) {
        this.setAttribute("hidden", h);
    }

    @Override
    public int getTabIndex() {
        return this.getAttributeInt("tabindex");
    }

    @Override
    public void setTabIndex(int t) {
        this.setAttribute("tabindex", t);
    }

    @Override
    public String getAccessKey() {
        return this.getAttribute("accesskey");
    }

    @Override
    public void setAccessKey(String key) {
        this.setAttribute("accesskey", key);
    }

    @Override
    public String getAccessKeyLabel() {
        return "";
    }

    @Override
    public String getContentEditable() {
        throw new NotImplementedException();
    }

    @Override
    public void setContentEditable(String s) {
        throw new NotImplementedException();
    }

    @Override
    public boolean isContentEditable() {
        throw new NotImplementedException();
    }

    @Override
    public boolean getSpellcheck() {
        throw new NotImplementedException();
    }

    @Override
    public void setSpellcheck(boolean b) {
        throw new NotImplementedException();
    }

    @Override
    public void blur() {
    }

    @Override
    public void focus() {
    }

    @Override
    public void click() {
    }

    @Override
    public Attr getAttributeNodeNS(String namespace, String key) {
        if (namespace != null && 0 < namespace.length()) {
            return super.getAttributeNodeNS(namespace, key);
        }
        return super.getAttributeNode(key);
    }

    protected String getAttribute(String key, String def) {
        if (this.hasAttribute(key)) {
            return this.getAttribute(key);
        }
        return def;
    }

    @Override
    public String getAttributeNS(String namespace, String key) {
        if (namespace != null && 0 < namespace.length()) {
            return super.getAttributeNS(namespace, key);
        }
        return super.getAttribute(key);
    }

    @Override
    public HTMLCollection<HTMLElement> getElementsByTagName(String tag) {
        tag = tag.toLowerCase(Locale.ENGLISH);
        NodeList nodes = super.getElementsByTagName(tag);
        HTMLCollectionImp<HTMLElement> collection = new HTMLCollectionImp<HTMLElement>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            HTMLElement e = (HTMLElement)nodes.item(i);
            collection.add(e);
        }
        return collection;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespace, String tag) {
        tag = tag.toLowerCase(Locale.ENGLISH);
        if (namespace != null && 0 < namespace.length()) {
            return super.getElementsByTagNameNS(namespace, tag);
        }
        return super.getElementsByTagName(tag);
    }

    @Override
    public String getTagName() {
        return super.getTagName();
    }

    protected String capitalize(String value) {
        char[] chars = value.toCharArray();
        int length = chars.length;
        if (0 < length) {
            chars[0] = Character.toUpperCase(chars[0]);
            for (int i = 1; i < length; ++i) {
                char c = chars[i];
                chars[i] = Character.toLowerCase(c);
            }
            return String.valueOf(chars);
        }
        return value;
    }

    protected String yesNo(boolean b) {
        return b ? "yes" : "no";
    }

    protected boolean getAttributeBoolean(String key) {
        NamedNodeMap attributes = this.getAttributes();
        Node attribute = attributes.getNamedItem(key);
        return attribute != null;
    }

    protected void setAttribute(String key, boolean b) {
        if (b) {
            this.setAttribute(key, key);
        } else {
            this.removeAttribute(key);
        }
    }

    protected int getAttributeInt(String key) {
        return this.getAttribute(key, 0);
    }

    protected int getAttribute(String key, int def) {
        try {
            String s = this.getAttribute(key);
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    protected void setAttribute(String key, int i) {
        this.setAttribute(key, Integer.toString(i));
    }

    protected double getAttributeDouble(String key) {
        return this.getAttribute(key, 0.0);
    }

    protected double getAttribute(String key, double def) {
        try {
            String s = this.getAttribute(key);
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    protected void setAttribute(String key, double d) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.ENGLISH);
        DecimalFormat df = new DecimalFormat("0", symbols);
        df.setMaximumFractionDigits(340);
        String s = df.format(d);
        this.setAttribute(key, s);
    }

    protected long getAttributeLong(String key) {
        try {
            String s = this.getAttribute(key);
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    protected void setAttribute(String key, long i) {
        this.setAttribute(key, Long.toString(i));
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            DocumentWriter r = new DocumentWriter(writer);
            ((DocumentRecurser)r).element(this);
            return writer.toString();
        }
        catch (Exception e) {
            return "<" + this.getTagName() + ">";
        }
    }

    protected HTMLElement createElement(String tag) {
        HTMLDocument document = this.getOwnerDocument();
        return document.createElement(tag);
    }

    protected <T extends HTMLElement> T createElement(Class<T> c) {
        HTMLDocument document = this.getOwnerDocument();
        return document.createElement(c);
    }

    protected HTMLElement getElementByTagName(String tag) {
        NodeList nodes = this.getElementsByTagName(tag);
        if (nodes.getLength() == 0) {
            return null;
        }
        return (HTMLElement)nodes.item(0);
    }

    @Override
    public boolean has(String key) {
        return this.hasAttribute(key);
    }

    @Override
    public String get(String key) {
        return this.getAttribute(key);
    }

    @Override
    public void set(String key, String value) {
        this.setAttribute(key, value);
    }

    @Override
    public void set(String key, int value) {
        this.setAttribute(key, value);
    }

    @Override
    public void deleter(String key) {
        this.removeAttribute(key);
    }
}

