/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.HTMLCollection;
import cat.inspiracio.html.HTMLDocument;
import cat.inspiracio.html.HTMLElement;
import cat.inspiracio.html.HTMLFieldSetElement;
import cat.inspiracio.html.HTMLFormControlsCollection;
import cat.inspiracio.html.HTMLFormElement;
import cat.inspiracio.html.HTMLHtmlElement;
import cat.inspiracio.html.HTMLInputElement;
import cat.inspiracio.html.ListedElement;
import cat.inspiracio.html.RadioNodeListImp;
import cat.inspiracio.html.ReassociateableElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class HTMLFormControlsCollectionImp
implements HTMLFormControlsCollection {
    private static final long serialVersionUID = -2810559074217028999L;
    protected List<ListedElement> elements = new ArrayList<ListedElement>();
    private Filter filter;

    HTMLFormControlsCollectionImp(HTMLFieldSetElement f) {
        this.filter = new Filter(){

            @Override
            public boolean accept(HTMLElement e) {
                return e instanceof ListedElement;
            }
        };
        HTMLCollection<HTMLElement> children = f.getChildElements();
        for (int i = 0; i < children.getLength(); ++i) {
            HTMLElement child = children.item(i);
            this.addAll(child);
        }
    }

    HTMLFormControlsCollectionImp(final HTMLFormElement form) {
        this.filter = new Filter(){

            @Override
            public boolean accept(HTMLElement e) {
                if (!(e instanceof ReassociateableElement)) {
                    return false;
                }
                ReassociateableElement le = (ReassociateableElement)((Object)e);
                HTMLFormElement f = le.getForm();
                if (f != form) {
                    return false;
                }
                if (e instanceof HTMLInputElement) {
                    HTMLInputElement input = (HTMLInputElement)le;
                    return !"image".equals(input.getType());
                }
                return true;
            }
        };
        HTMLDocument d = form.getOwnerDocument();
        if (d == null) {
            this.addAll(form);
        } else {
            HTMLHtmlElement e = d.getDocumentElement();
            this.addAll(e);
        }
    }

    private void addAll(HTMLElement element) {
        if (this.filter.accept(element)) {
            this.add((ListedElement)element);
        }
        HTMLCollection<HTMLElement> children = element.getChildElements();
        for (HTMLElement child : children) {
            this.addAll(child);
        }
    }

    public void add(ListedElement e) {
        this.elements.add(e);
    }

    @Override
    public int getLength() {
        return this.elements.size();
    }

    @Override
    public ListedElement item(int index) {
        if (index < 0 || this.elements.size() <= index) {
            return null;
        }
        return this.elements.get(index);
    }

    @Override
    public Object namedItem(String name) {
        if (name == null || 0 == name.length()) {
            return null;
        }
        RadioNodeListImp radios = new RadioNodeListImp();
        for (ListedElement e : this.elements) {
            boolean in = name.equals(e.getId()) || name.equals(e.getName());
            if (!in) continue;
            radios.add(e);
        }
        int length = radios.getLength();
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return radios.item(0);
        }
        return radios;
    }

    public String toString() {
        return this.elements.toString();
    }

    @Override
    public Iterator<ListedElement> iterator() {
        return this.elements.iterator();
    }

    private static interface Filter {
        public boolean accept(HTMLElement var1);
    }
}

