/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.html.EncType;
import cat.inspiracio.html.HTMLDocument;
import cat.inspiracio.html.HTMLDocumentImp;
import cat.inspiracio.html.HTMLElement;
import cat.inspiracio.html.HTMLElementImp;
import cat.inspiracio.html.HTMLFormControlsCollection;
import cat.inspiracio.html.HTMLFormControlsCollectionImp;
import cat.inspiracio.html.HTMLFormElement;
import cat.inspiracio.html.HTMLImageElement;
import cat.inspiracio.html.ListedElement;
import cat.inspiracio.html.RadioNodeListImp;
import cat.inspiracio.lang.NotImplementedException;
import org.w3c.dom.NodeList;

class HTMLFormElementImp
extends HTMLElementImp
implements HTMLFormElement {
    private static final long serialVersionUID = 11269356676270397L;

    HTMLFormElementImp(HTMLDocumentImp owner) {
        super(owner, "form");
    }

    @Override
    public HTMLFormElement cloneNode(boolean deep) {
        return (HTMLFormElement)super.cloneNode(deep);
    }

    @Override
    public String getAcceptCharset() {
        return this.getAttribute("accept-charset");
    }

    @Override
    public void setAcceptCharset(String accept) {
        this.setAttribute("accept-charset", accept);
    }

    @Override
    public String getAction() {
        if (this.hasAttribute("action")) {
            return this.getAttribute("action");
        }
        HTMLDocument document = this.getOwnerDocument();
        return document.getDocumentURI();
    }

    @Override
    public void setAction(String action) {
        this.setAttribute("action", action);
    }

    @Override
    public String getAutocomplete() {
        return this.getAttribute("autocomplete");
    }

    @Override
    public void setAutocomplete(String auto) {
        this.setAttribute("autocomplete", auto);
    }

    @Override
    public String getEnctype() {
        if (!this.hasAttribute("enctype")) {
            return "";
        }
        String s = this.getAttribute("enctype");
        boolean valid = EncType.isValid(s);
        if (valid) {
            return s;
        }
        return EncType.getInvalidDefault().toString();
    }

    @Override
    public void setEnctype(String enc) {
        boolean valid = EncType.isValid(enc);
        if (!valid) {
            enc = EncType.getInvalidDefault().toString();
        }
        this.setAttribute("enctype", enc);
    }

    @Override
    public String getEncoding() {
        return this.getEnctype();
    }

    @Override
    public void setEncoding(String s) {
        this.setEnctype(s);
    }

    @Override
    public String getMethod() {
        return this.getAttribute("method");
    }

    @Override
    public void setMethod(String s) {
        this.setAttribute("method", s);
    }

    @Override
    public boolean getNoValidate() {
        return this.getAttributeBoolean("novalidate");
    }

    @Override
    public void setNoValidate(boolean b) {
        this.setAttribute("novalidate", b);
    }

    @Override
    public int getLength() {
        HTMLFormControlsCollection controls = this.getElements();
        if (controls == null) {
            return 0;
        }
        return controls.getLength();
    }

    @Override
    public String getTarget() {
        return this.getAttribute("target");
    }

    @Override
    public void setTarget(String s) {
        this.setAttribute("target", s);
    }

    @Override
    public HTMLFormControlsCollection getElements() {
        return new HTMLFormControlsCollectionImp(this);
    }

    @Override
    public HTMLElement item(int index) {
        HTMLFormControlsCollection elements = this.getElements();
        if (elements == null) {
            return null;
        }
        return elements.item(index);
    }

    @Override
    public Object namedItem(String name) {
        if (name == null || 0 == name.length()) {
            return null;
        }
        RadioNodeListImp candidates = new RadioNodeListImp();
        HTMLFormControlsCollection controls = this.getElements();
        if (controls != null) {
            for (ListedElement e : controls) {
                if (!name.equals(e.getId()) && !name.equals(e.getName())) continue;
                candidates.add(e);
            }
        }
        if (candidates.getLength() == 0) {
            NodeList images = this.getElementsByTagName("img");
            for (int i = 0; i < images.getLength(); ++i) {
                HTMLImageElement image = (HTMLImageElement)images.item(i);
                if (!name.equals(image.getId()) && !name.equals(image.getName())) continue;
                candidates.add(image);
            }
        }
        if (candidates.getLength() == 0) {
            throw new NotImplementedException();
        }
        if (1 < candidates.getLength()) {
            return candidates;
        }
        return candidates.item(0);
    }

    @Override
    public void submit() {
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean checkValidity() {
        throw new NotImplementedException();
    }
}

