/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.InvalidStateError;
import cat.inspiracio.file.File;
import cat.inspiracio.html.EncType;
import cat.inspiracio.html.HTMLDataListElement;
import cat.inspiracio.html.HTMLDocument;
import cat.inspiracio.html.HTMLDocumentImp;
import cat.inspiracio.html.HTMLElement;
import cat.inspiracio.html.HTMLFormElement;
import cat.inspiracio.html.HTMLInputElement;
import cat.inspiracio.html.LabelableElementImp;
import cat.inspiracio.html.SelectionMode;
import cat.inspiracio.html.ValidityState;
import cat.inspiracio.lang.NotImplementedException;
import cat.inspiracio.script.TypeError;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

class HTMLInputElementImp
extends LabelableElementImp
implements HTMLInputElement {
    private static final long serialVersionUID = -1758402136570933694L;
    private static final String DATE_PATTERN = "yyyy-MM-dd";

    HTMLInputElementImp(HTMLDocumentImp owner) {
        super(owner, "input");
    }

    @Override
    public HTMLInputElement cloneNode(boolean deep) {
        return (HTMLInputElement)super.cloneNode(deep);
    }

    @Override
    public String getAccept() {
        return this.getAttribute("accept");
    }

    @Override
    public void setAccept(String accept) {
        this.setAttribute("accept", accept);
    }

    @Override
    public String getAlt() {
        return this.getAttribute("alt");
    }

    @Override
    public void setAlt(String alt) {
        this.setAttribute("alt", alt);
    }

    @Override
    public String getAutocomplete() {
        return this.getAttribute("autocomplete");
    }

    @Override
    public void setAutocomplete(String s) {
        this.setAttribute("autocomplete", s);
    }

    @Override
    public boolean getAutofocus() {
        return this.getAttributeBoolean("autofocus");
    }

    @Override
    public void setAutofocus(boolean auto) {
        this.setAttribute("autofocus", auto);
    }

    @Override
    public boolean getDefaultChecked() {
        return this.getAttributeBoolean("checked");
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.setAttribute("checked", defaultChecked);
    }

    @Override
    public boolean getChecked() {
        return this.getAttributeBoolean("checked");
    }

    @Override
    public void setChecked(boolean checked) {
        this.setAttribute("checked", checked);
    }

    @Override
    public String getDirName() {
        return this.getAttribute("dirname");
    }

    @Override
    public void setDirName(String name) {
        this.setAttribute("dirname", name);
    }

    @Override
    public boolean getDisabled() {
        return this.getAttributeBoolean("disabled");
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.setAttribute("disabled", disabled);
    }

    @Override
    public HTMLFormElement getForm() {
        if (this.hasAttribute("form")) {
            String id = this.getAttribute("form");
            return (HTMLFormElement)this.getElementById(id);
        }
        return super.getForm();
    }

    @Override
    public List<File> getFiles() {
        return new ArrayList<File>();
    }

    @Override
    public String getFormAction() {
        String action = this.getAttribute("formaction");
        if (action == null || 0 == action.length()) {
            HTMLDocument d = this.getOwnerDocument();
            return d.getURL();
        }
        return action;
    }

    @Override
    public void setFormAction(String action) {
        this.setAttribute("formaction", action);
    }

    @Override
    public String getFormEncType() {
        if (!this.hasAttribute("formenctype")) {
            return "";
        }
        String s = this.getAttribute("formenctype");
        boolean valid = EncType.isValid(s);
        if (valid) {
            return s;
        }
        return EncType.getInvalidDefault().toString();
    }

    @Override
    public void setFormEncType(String enc) {
        boolean valid = EncType.isValid(enc);
        if (!valid) {
            enc = EncType.getInvalidDefault().toString();
        }
        this.setAttribute("formenctype", enc);
    }

    @Override
    public String getFormMethod() {
        return this.getAttribute("formmethod");
    }

    @Override
    public void setFormMethod(String method) {
        this.setAttribute("formmethod", method);
    }

    @Override
    public boolean getFormNoValidate() {
        return this.getAttributeBoolean("formnovalidate");
    }

    @Override
    public void setFormNoValidate(boolean b) {
        this.setAttribute("formnovalidate", b);
    }

    @Override
    public String getFormTarget() {
        return this.getAttribute("formtarget");
    }

    @Override
    public void setFormTarget(String target) {
        this.setAttribute("formtarget", target);
    }

    @Override
    public int getHeight() {
        return this.getAttributeInt("height");
    }

    @Override
    public void setHeight(int height) {
        this.setAttribute("height", height);
    }

    @Override
    public boolean getIndeterminate() {
        return this.getAttributeBoolean("indeterminate");
    }

    @Override
    public void setIndeterminate(boolean in) {
        this.setAttribute("indeterminate", in);
    }

    @Override
    public HTMLElement getList() {
        String list = this.getAttribute("list");
        if (list == null || 0 == list.length()) {
            return null;
        }
        HTMLDocument d = this.getOwnerDocument();
        HTMLElement e = d.getElementById(list);
        if (e == null) {
            return null;
        }
        if (e instanceof HTMLDataListElement) {
            return (HTMLDataListElement)e;
        }
        return null;
    }

    @Override
    public String getMax() {
        return this.getAttribute("max");
    }

    @Override
    public void setMax(String max) {
        this.setAttribute("max", max);
    }

    @Override
    public int getMaxLength() {
        return this.getAttributeInt("maxlength");
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.setAttribute("maxlength", maxLength);
    }

    @Override
    public String getMin() {
        return this.getAttribute("min");
    }

    @Override
    public void setMin(String min) {
        this.setAttribute("min", min);
    }

    @Override
    public int getMinLength() {
        return this.getAttributeInt("minlength");
    }

    @Override
    public void setMinLength(int length) {
        this.setAttribute("minlength", length);
    }

    @Override
    public boolean getMultiple() {
        return this.getAttributeBoolean("multiple");
    }

    @Override
    public void setMultiple(boolean multiple) {
        this.setAttribute("multiple", multiple);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public String getPattern() {
        return this.getAttribute("pattern");
    }

    @Override
    public void setPattern(String pattern) {
        this.setAttribute("pattern", pattern);
    }

    @Override
    public String getPlaceHolder() {
        return this.getAttribute("placeholder");
    }

    @Override
    public void setPlaceHolder(String holder) {
        this.setAttribute("placeholder", holder);
    }

    @Override
    public boolean getReadOnly() {
        return this.getAttributeBoolean("readonly");
    }

    @Override
    public void setReadOnly(boolean only) {
        this.setAttribute("readonly", only);
    }

    @Override
    public boolean getRequired() {
        return this.getAttributeBoolean("required");
    }

    @Override
    public void setRequired(boolean required) {
        this.setAttribute("required", required);
    }

    @Override
    public int getSize() {
        return this.getAttributeInt("size");
    }

    @Override
    public void setSize(int size) {
        this.setAttribute("size", size);
    }

    @Override
    public String getSrc() {
        return this.getAttribute("src");
    }

    @Override
    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    @Override
    public String getStep() {
        return this.getAttribute("step");
    }

    @Override
    public void setStep(String step) {
        this.setAttribute("step", step);
    }

    @Override
    public String getType() {
        return this.getAttribute("type");
    }

    @Override
    public void setType(String type) {
        if (null != type) {
            type = type.toLowerCase();
        }
        this.setAttribute("type", type);
    }

    private boolean isButton() {
        return "button".equals(this.getType());
    }

    private boolean isCheckBox() {
        return "checkbox".equals(this.getType());
    }

    private boolean isColor() {
        return "color".equals(this.getType());
    }

    private boolean isDate() {
        return "date".equals(this.getType());
    }

    private boolean isEmail() {
        return "email".equals(this.getType());
    }

    private boolean isFile() {
        return "file".equals(this.getType());
    }

    private boolean isHidden() {
        return "hidden".equals(this.getType());
    }

    private boolean isImage() {
        return "image".equals(this.getType());
    }

    private boolean isNumber() {
        return "number".equals(this.getType());
    }

    private boolean isPassword() {
        return "password".equals(this.getType());
    }

    private boolean isRadio() {
        return "radio".equals(this.getType());
    }

    private boolean isRange() {
        return "range".equals(this.getType());
    }

    private boolean isReset() {
        return "reset".equals(this.getType());
    }

    private boolean isSearch() {
        return "search".equals(this.getType());
    }

    private boolean isSubmit() {
        return "submit".equals(this.getType());
    }

    private boolean isTel() {
        return "tel".equals(this.getType());
    }

    private boolean isText() {
        return "text".equals(this.getType());
    }

    private boolean isTime() {
        return "time".equals(this.getType());
    }

    private boolean isURL() {
        return "url".equals(this.getType());
    }

    @Override
    public String getDefaultValue() {
        return this.getAttribute("value");
    }

    @Override
    public void setDefaultValue(String v) {
        this.setAttribute("value", v);
    }

    @Override
    public String getValue() {
        return this.getAttribute("value");
    }

    @Override
    public void setValue(String v) {
        if (v == null || 0 == v.length()) {
            this.removeAttribute("value");
        } else {
            this.setAttribute("value", v);
        }
    }

    @Override
    public Date getValueAsDate() {
        if (!this.isDate() && !this.isTime()) {
            return null;
        }
        String value = this.getValue();
        if (this.isDate()) {
            return this.parseDate(value);
        }
        if (this.isTime()) {
            return this.parseTime(value);
        }
        return null;
    }

    @Override
    public void setValueAsDate(Date d) {
        if (!this.isDate() && !this.isTime()) {
            throw new InvalidStateError();
        }
        if (this.isDate()) {
            String s = this.formatDate(d);
            this.setAttribute("value", s);
            return;
        }
        if (this.isTime()) {
            String s = this.formatTime(d);
            this.setAttribute("value", s);
            return;
        }
    }

    @Override
    public double getValueAsNumber() {
        if (!(this.isDate() || this.isTime() || this.isNumber() || this.isRange())) {
            return Double.NaN;
        }
        if (this.isDate() || this.isTime()) {
            Date d = this.getValueAsDate();
            if (d == null) {
                return Double.NaN;
            }
            return d.getTime();
        }
        return this.getAttribute("value", Double.NaN);
    }

    @Override
    public void setValueAsNumber(double v) {
        if (Double.isInfinite(v)) {
            throw new TypeError();
        }
        if (!(this.isDate() || this.isTime() || this.isNumber() || this.isRange())) {
            throw new InvalidStateError();
        }
        if (Double.isNaN(v)) {
            this.setValue("");
            return;
        }
        if (this.isDate() || this.isTime()) {
            long l = Math.round(v);
            Date d = new Date(l);
            this.setValueAsDate(d);
            return;
        }
        this.setAttribute("value", v);
    }

    @Override
    public int getWidth() {
        return this.getAttributeInt("width");
    }

    @Override
    public void setWidth(int width) {
        this.setAttribute("width", width);
    }

    @Override
    public void stepDown() {
        this.step(-1);
    }

    @Override
    public void stepDown(int n) {
        this.step(-n);
    }

    @Override
    public void stepUp() {
        this.step(1);
    }

    @Override
    public void stepUp(int n) {
        this.step(n);
    }

    private void step(int n) throws InvalidStateError {
        boolean inStep;
        boolean down;
        if (n == 0) {
            return;
        }
        boolean bl = down = n < 0;
        if (!this.stepApplies()) {
            throw new InvalidStateError();
        }
        double step = this.step();
        double min = this.min();
        double max = this.max();
        if (this.isNumber(min) && this.isNumber(max) && max < min) {
            return;
        }
        double value = this.getValueAsNumber();
        if (this.isNumber(value)) {
            double maxValid;
            double minValid;
            if (down ? this.isNumber(minValid = this.minValid()) && value < minValid : this.isNumber(maxValid = this.maxValid()) && maxValid < value) {
                return;
            }
        } else {
            value = this.defaultValue();
        }
        if (!(inStep = this.isInStep(value))) {
            value = this.inStep(value, down);
            int n2 = n = down ? n + 1 : n - 1;
        }
        if (n != 0) {
            double delta = step * (double)n;
            value += delta;
        }
        if (this.isDate() && this.NS_floorModulo(value - this.base(), this.factor()) != 0.0) {
            double validStep = this.EuclidLCM((long)Math.floor(this.step()), (long)Math.floor(this.factor()));
            if (0 < n) {
                value -= this.NS_floorModulo(value - this.base(), validStep);
                value += validStep;
            } else if (n < 0) {
                value -= this.NS_floorModulo(value - this.base(), validStep);
            }
        }
        value = this.adjustBelowMin(value);
        value = this.adjustAboveMax(value);
        this.setValueAsNumber(value);
    }

    private long EuclidLCM(long aA, long aB) {
        return aA / this.EuclidGCD(aA, aB) * aB;
    }

    private long EuclidGCD(long aA, long aB) {
        assert (0L < aA);
        assert (0L < aB);
        while (aA != aB) {
            if (aB < aA) {
                aA -= aB;
                continue;
            }
            aB -= aA;
        }
        return aA;
    }

    private double defaultValue() {
        if (this.isRange()) {
            double min = this.min();
            double max = this.max();
            if (max < min) {
                return min;
            }
            double diff = max - min;
            return min + diff / 2.0;
        }
        return 0.0;
    }

    private double NS_floorModulo(double x, double y) {
        return x - y * Math.floor(x / y);
    }

    private double inStep(double value, boolean down) {
        return down ? this.lower(value) : this.raise(value);
    }

    private double minValid() {
        double min = this.min();
        if (Double.isNaN(min)) {
            return Double.NaN;
        }
        return this.raise(min);
    }

    private double maxValid() {
        double max = this.max();
        if (Double.isNaN(max)) {
            return Double.NaN;
        }
        return this.lower(max);
    }

    private double raise(double d) {
        double base = this.base();
        if (base == d) {
            return d;
        }
        double diff = d - base;
        double step = this.step();
        double steps = diff / step;
        if (this.isIntegral(steps)) {
            return d;
        }
        steps = Math.ceil(steps);
        diff = steps * step;
        d = base + diff;
        return d;
    }

    private boolean isInStep(double d) {
        double base = this.base();
        if (base == d) {
            return true;
        }
        double step = this.step();
        double diff = d - base;
        double steps = diff / step;
        return this.isIntegral(steps);
    }

    private double lower(double d) {
        double base = this.base();
        if (base == d) {
            return d;
        }
        double diff = d - base;
        double step = this.step();
        double steps = diff / step;
        if (this.isIntegral(steps)) {
            return d;
        }
        steps = Math.floor(steps);
        diff = steps * step;
        d = base + diff;
        return d;
    }

    private double adjustBelowMin(double value) {
        double min = this.min();
        if (this.isNumber(min) && value < min) {
            value = this.minValid();
        }
        return value;
    }

    private double adjustAboveMax(double value) {
        double max = this.max();
        if (this.isNumber(max) && max < value) {
            value = this.maxValid();
        }
        return value;
    }

    private boolean stepApplies() {
        return this.isDate() || this.isTime() || this.isNumber() || this.isRange();
    }

    private double convertToDouble(String s) throws NumberFormatException {
        if (this.isNumber() || this.isRange()) {
            return this.parseDouble(s);
        }
        if (this.isDate()) {
            Date d = this.parseDate(s);
            if (d == null) {
                throw new NumberFormatException(s);
            }
            long ms = d.getTime();
            return ms;
        }
        if (this.isTime()) {
            Date d = this.parseTime(s);
            if (d == null) {
                throw new NumberFormatException(s);
            }
            long ms = d.getTime();
            return ms;
        }
        return this.parseDouble(s);
    }

    private double parseDouble(String s) {
        return Double.parseDouble(s);
    }

    private boolean isIntegral(double d) {
        return d == Math.rint(d);
    }

    private boolean isNumber(double d) {
        return !Double.isNaN(d);
    }

    private double base() {
        double min = this.min();
        if (this.isNumber(min)) {
            return min;
        }
        double v = this.getValueAsNumber();
        if (this.isNumber(v)) {
            return v;
        }
        return 0.0;
    }

    private double min() {
        try {
            String min = this.getMin();
            return this.convertToDouble(min);
        }
        catch (NumberFormatException e) {
            return this.defaultMinimum();
        }
    }

    private double max() {
        try {
            String max = this.getMax();
            return this.convertToDouble(max);
        }
        catch (NumberFormatException e) {
            return this.defaultMaximum();
        }
    }

    private double defaultMaximum() {
        if (this.isRange()) {
            return 100.0;
        }
        return Double.NaN;
    }

    private double defaultMinimum() {
        if (this.isRange()) {
            return 0.0;
        }
        return Double.NaN;
    }

    private double step() throws InvalidStateError {
        if (!this.has("step")) {
            return this.defaultStep() * (double)this.factor();
        }
        String s = this.getStep();
        if ("any".equalsIgnoreCase(s)) {
            throw new InvalidStateError();
        }
        try {
            double step = this.parseDouble(s);
            if (step <= 0.0) {
                return this.defaultStep() * (double)this.factor();
            }
            return step * (double)this.factor();
        }
        catch (NumberFormatException e) {
            return this.defaultStep() * (double)this.factor();
        }
    }

    private double defaultStep() {
        if (this.isDate()) {
            return 1.0;
        }
        if (this.isTime()) {
            return 60.0;
        }
        if (this.isNumber()) {
            return 1.0;
        }
        if (this.isRange()) {
            return 1.0;
        }
        throw new NotImplementedException();
    }

    private int factor() {
        if (this.isDate()) {
            return 86400000;
        }
        if (this.isTime()) {
            return 1000;
        }
        if (this.isNumber()) {
            return 1;
        }
        if (this.isRange()) {
            return 1;
        }
        throw new NotImplementedException();
    }

    @Override
    public boolean getWillValidate() {
        throw new NotImplementedException();
    }

    @Override
    public ValidityState getValidity() {
        throw new NotImplementedException();
    }

    @Override
    public String getValidationMessage() {
        throw new NotImplementedException();
    }

    @Override
    public boolean checkValidity() {
        throw new NotImplementedException();
    }

    @Override
    public void setCustomValidity(String error) {
        throw new NotImplementedException();
    }

    @Override
    public void select() {
        throw new NotImplementedException();
    }

    @Override
    public int getSelectionStart() {
        throw new NotImplementedException();
    }

    @Override
    public void setSelectionStart(int start) {
        throw new NotImplementedException();
    }

    @Override
    public int getSelectionEnd() {
        throw new NotImplementedException();
    }

    @Override
    public void setSelectionEnd(int end) {
        throw new NotImplementedException();
    }

    @Override
    public String getSelectionDirection() {
        throw new NotImplementedException();
    }

    @Override
    public void setSelectionDirection(String direction) {
        throw new NotImplementedException();
    }

    @Override
    public void setRangeText(String replacement) {
        throw new NotImplementedException();
    }

    @Override
    public void setRangeText(String replacement, int start, int end) {
        throw new NotImplementedException();
    }

    @Override
    public void setRangeText(String replacement, int start, int end, SelectionMode mode) {
        throw new NotImplementedException();
    }

    @Override
    public void setRangeText(String replacement, int start, int end, String direction) {
        throw new NotImplementedException();
    }

    private Date parseDate(String s) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
            TimeZone utf = TimeZone.getTimeZone("GMT");
            format.setTimeZone(utf);
            return format.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }

    Date parseTime(String s) {
        if (s == null || 0 == s.length()) {
            return null;
        }
        TimeZone utf = TimeZone.getTimeZone("GMT");
        try {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.S");
            format.setTimeZone(utf);
            return format.parse(s);
        }
        catch (ParseException format) {
            try {
                SimpleDateFormat format2 = new SimpleDateFormat("HH:mm:ss");
                format2.setTimeZone(utf);
                return format2.parse(s);
            }
            catch (ParseException format2) {
                try {
                    SimpleDateFormat format3 = new SimpleDateFormat("HH:mm");
                    format3.setTimeZone(utf);
                    return format3.parse(s);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
        }
    }

    private String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        TimeZone utf = TimeZone.getTimeZone("GMT");
        format.setTimeZone(utf);
        return format.format(date);
    }

    private String formatTime(Date date) {
        TimeZone utf = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance(utf);
        calendar.setTime(date);
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        int millis = calendar.get(14);
        StringBuilder builder = new StringBuilder();
        if (hours < 10) {
            builder.append('0');
        }
        builder.append(hours).append(':');
        if (minutes < 10) {
            builder.append('0');
        }
        builder.append(minutes);
        if (0 < seconds || 0 < millis) {
            builder.append(':');
            if (seconds < 10) {
                builder.append('0');
            }
            builder.append(seconds);
            if (0 < millis) {
                builder.append('.').append(millis);
            }
        }
        return builder.toString();
    }
}

