/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.HTMLCollection;
import cat.inspiracio.html.HTMLDocument;
import cat.inspiracio.html.HTMLDocumentImp;
import cat.inspiracio.html.HTMLElement;
import cat.inspiracio.html.HTMLElementImp;
import cat.inspiracio.html.HTMLFormElement;
import cat.inspiracio.html.HTMLLabelElement;
import cat.inspiracio.html.LabelableElement;

class HTMLLabelElementImp
extends HTMLElementImp
implements HTMLLabelElement {
    private static final long serialVersionUID = -6947172960276305099L;

    HTMLLabelElementImp(HTMLDocumentImp owner) {
        super(owner, "label");
    }

    @Override
    public HTMLLabelElement cloneNode(boolean deep) {
        return (HTMLLabelElement)super.cloneNode(deep);
    }

    @Override
    public HTMLFormElement getForm() {
        if (this.hasAttribute("form")) {
            String id = this.getAttribute("form");
            return (HTMLFormElement)this.getElementById(id);
        }
        return super.getForm();
    }

    @Override
    public String getHtmlFor() {
        return this.getAttribute("for");
    }

    @Override
    public void setHtmlFor(String s) {
        this.setAttribute("for", s);
    }

    @Override
    public HTMLElement getControl() {
        if (this.hasAttribute("for")) {
            HTMLDocument d = this.getOwnerDocument();
            if (d == null) {
                return null;
            }
            return d.getElementById(this.getHtmlFor());
        }
        return this.getFirstLabelableDescendant(this);
    }

    public LabelableElement getFirstLabelableDescendant(HTMLElement e) {
        HTMLCollection<HTMLElement> children = e.getChildElements();
        for (HTMLElement child : children) {
            if (child instanceof LabelableElement) {
                return (LabelableElement)child;
            }
            LabelableElement f = this.getFirstLabelableDescendant(child);
            if (f == null) continue;
            return f;
        }
        return null;
    }
}

