/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.HTMLCollection;
import cat.inspiracio.dom.HTMLCollectionImp;
import cat.inspiracio.html.HTMLAreaElement;
import cat.inspiracio.html.HTMLDocument;
import cat.inspiracio.html.HTMLDocumentImp;
import cat.inspiracio.html.HTMLElement;
import cat.inspiracio.html.HTMLElementImp;
import cat.inspiracio.html.HTMLHtmlElement;
import cat.inspiracio.html.HTMLImageElement;
import cat.inspiracio.html.HTMLMapElement;
import cat.inspiracio.html.HTMLObjectElement;
import org.w3c.dom.NodeList;

class HTMLMapElementImp
extends HTMLElementImp
implements HTMLMapElement {
    private static final long serialVersionUID = 3721702365769252368L;

    HTMLMapElementImp(HTMLDocumentImp owner) {
        super(owner, "map");
    }

    @Override
    public HTMLMapElement cloneNode(boolean deep) {
        return (HTMLMapElement)super.cloneNode(deep);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public void setName(String n) {
        this.setAttribute("name", n);
    }

    @Override
    public HTMLCollectionImp<HTMLAreaElement> getAreas() {
        NodeList nodes = this.getElementsByTagName("area");
        HTMLCollectionImp<HTMLAreaElement> areas = new HTMLCollectionImp<HTMLAreaElement>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            areas.add((HTMLAreaElement)nodes.item(i));
        }
        return areas;
    }

    @Override
    public HTMLCollection<HTMLElement> getImages() {
        HTMLCollectionImp.Filter filter = new HTMLCollectionImp.Filter(){

            @Override
            public boolean accept(HTMLElement e) {
                if (e instanceof HTMLImageElement) {
                    HTMLImageElement image = (HTMLImageElement)e;
                    String use = this.use(image.getUseMap());
                    return this.match(use);
                }
                if (e instanceof HTMLObjectElement) {
                    HTMLObjectElement object = (HTMLObjectElement)e;
                    String use = this.use(object.getUseMap());
                    return this.match(use);
                }
                return false;
            }

            String use(String usemap) {
                if (!usemap.startsWith("#")) {
                    return null;
                }
                return usemap.substring(1);
            }

            boolean match(String use) {
                if (use == null) {
                    return false;
                }
                if (use.equals(HTMLMapElementImp.this.getId())) {
                    return true;
                }
                return use.equalsIgnoreCase(HTMLMapElementImp.this.getName());
            }
        };
        HTMLDocument d = this.getOwnerDocument();
        if (d == null) {
            return null;
        }
        HTMLHtmlElement root = d.getDocumentElement();
        if (root == null) {
            return null;
        }
        HTMLCollectionImp<HTMLElement> images = new HTMLCollectionImp<HTMLElement>(root, filter);
        return images;
    }
}

