/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.HierarchyRequestError;
import cat.inspiracio.dom.NotFoundError;
import cat.inspiracio.html.HTMLDocument;
import cat.inspiracio.html.HTMLElement;
import cat.inspiracio.html.HTMLOptGroupElement;
import cat.inspiracio.html.HTMLOptionElement;
import cat.inspiracio.html.HTMLOptionsCollection;
import cat.inspiracio.html.HTMLSelectElement;
import cat.inspiracio.lang.NotImplementedException;
import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class HTMLOptionsCollectionImp
implements HTMLOptionsCollection {
    private static final long serialVersionUID = 3214081886714905353L;
    private HTMLSelectElement select;

    HTMLOptionsCollectionImp(HTMLSelectElement s) {
        this.select = s;
    }

    @Override
    public Iterator<HTMLOptionElement> iterator() {
        final NodeList options = this.getOptions();
        return new Iterator<HTMLOptionElement>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < options.getLength();
            }

            @Override
            public HTMLOptionElement next() {
                return (HTMLOptionElement)options.item(this.index++);
            }

            @Override
            public void remove() {
                throw new NotImplementedException();
            }
        };
    }

    @Override
    public HTMLOptionElement item(int index) {
        return (HTMLOptionElement)this.getOptions().item(index);
    }

    @Override
    public int getLength() {
        return this.getOptions().getLength();
    }

    @Override
    public HTMLOptionElement get(String name) {
        return this.namedItem(name);
    }

    @Override
    public void set(int index, HTMLOptionElement option) {
        if (option == null) {
            this.remove(index);
            return;
        }
        NodeList options = this.getOptions();
        int length = options.getLength();
        int n = index - length;
        if (0 < n) {
            HTMLDocument document = this.select.getOwnerDocument();
            for (int i = 0; i < n; ++i) {
                HTMLElement o = document.createElement("option");
                this.select.appendChild(o);
            }
        }
        if (0 <= n) {
            this.select.appendChild(option);
        } else {
            Node o = options.item(index);
            this.select.replaceChild(option, o);
        }
    }

    @Override
    public void setLength(int length) {
        block4: {
            int old;
            NodeList options;
            block3: {
                options = this.getOptions();
                old = options.getLength();
                if (old == length) {
                    return;
                }
                if (old >= length) break block3;
                int n = length - old;
                HTMLDocument d = this.select.getOwnerDocument();
                for (int i = 0; i < n; ++i) {
                    HTMLElement o = d.createElement("option");
                    this.select.appendChild(o);
                }
                break block4;
            }
            if (length >= old) break block4;
            int n = old - length;
            for (int i = 0; i < n; ++i) {
                int last = old - i - 1;
                Node o = options.item(last);
                Node parent = o.getParentNode();
                parent.removeChild(o);
            }
        }
    }

    @Override
    public HTMLOptionElement namedItem(String name) {
        if (name == null || 0 == name.length()) {
            return null;
        }
        NodeList options = this.getOptions();
        int length = options.getLength();
        for (int i = 0; i < length; ++i) {
            HTMLOptionElement o = (HTMLOptionElement)options.item(i);
            String n = o.getName();
            if (!name.equals(n)) continue;
            return o;
        }
        return null;
    }

    @Override
    public void add(HTMLOptionElement option) {
        this.add(option, null);
    }

    private boolean isAncestor(HTMLElement ancestor, Node descendant) {
        if (ancestor == null) {
            return false;
        }
        if (descendant == null) {
            return false;
        }
        if (ancestor == descendant) {
            return false;
        }
        for (Node parent = descendant.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    @Override
    public void add(HTMLOptionElement option, HTMLElement before) {
        this._add((HTMLElement)option, before);
    }

    private void _add(HTMLElement element, Node before) {
        if (element == null) {
            return;
        }
        if (this.isAncestor(element, this.select)) {
            throw new HierarchyRequestError();
        }
        if (before != null && !this.isAncestor(this.select, before)) {
            throw new NotFoundError();
        }
        if (element == before) {
            return;
        }
        Node reference = before;
        Node parent = reference != null ? reference.getParentNode() : this.select;
        parent.insertBefore(element, reference);
    }

    @Override
    public void add(HTMLOptionElement option, int before) {
        this._add((HTMLElement)option, before);
    }

    private void _add(HTMLElement element, int before) {
        NodeList options = this.getOptions();
        Node reference = options.item(before);
        this._add(element, reference);
    }

    @Override
    public void add(HTMLOptGroupElement group) {
        this.add(group, null);
    }

    @Override
    public void add(HTMLOptGroupElement group, HTMLElement before) {
        this._add((HTMLElement)group, before);
    }

    @Override
    public void add(HTMLOptGroupElement group, int before) {
        this._add((HTMLElement)group, before);
    }

    @Override
    public void remove(int index) {
        NodeList options = this.getOptions();
        Node option = options.item(index);
        if (option == null) {
            return;
        }
        Node parent = option.getParentNode();
        parent.removeChild(option);
    }

    @Override
    public int getSelectedIndex() {
        for (int i = 0; i < this.getLength(); ++i) {
            HTMLOptionElement o = this.item(i);
            if (!o.getSelected()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setSelectedIndex(int index) {
        this.unselect();
        HTMLOptionElement o = this.item(index);
        if (o != null) {
            o.setSelected(true);
        }
    }

    private void unselect() {
        for (HTMLOptionElement o : this) {
            o.setSelected(false);
        }
    }

    private NodeList getOptions() {
        return this.select.getElementsByTagName("option");
    }

    public String toString() {
        return this.select.toString();
    }
}

