/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.HTMLCollection;
import cat.inspiracio.dom.HTMLCollectionImp;
import cat.inspiracio.html.HTMLDocumentImp;
import cat.inspiracio.html.HTMLElement;
import cat.inspiracio.html.HTMLFormElement;
import cat.inspiracio.html.HTMLOptGroupElement;
import cat.inspiracio.html.HTMLOptionElement;
import cat.inspiracio.html.HTMLOptionsCollection;
import cat.inspiracio.html.HTMLOptionsCollectionImp;
import cat.inspiracio.html.HTMLSelectElement;
import cat.inspiracio.html.LabelableElementImp;
import cat.inspiracio.html.ValidityState;
import cat.inspiracio.lang.NotImplementedException;

class HTMLSelectElementImp
extends LabelableElementImp
implements HTMLSelectElement {
    private static final long serialVersionUID = -124125383328444347L;

    HTMLSelectElementImp(HTMLDocumentImp owner) {
        super(owner, "select");
    }

    @Override
    public HTMLSelectElement cloneNode(boolean deep) {
        return (HTMLSelectElement)super.cloneNode(deep);
    }

    @Override
    public boolean has(int index) {
        HTMLOptionElement option = this.getOptions().item(index);
        return option != null;
    }

    @Override
    public HTMLOptionElement get(int index) {
        return this.getOptions().item(index);
    }

    @Override
    public void set(int index, HTMLOptionElement option) {
        this.getOptions().set(index, option);
    }

    @Override
    public void delete(int index) {
        this.getOptions().remove(index);
    }

    @Override
    public boolean getAutofocus() {
        return this.getAttributeBoolean("autofocus");
    }

    @Override
    public void setAutofocus(boolean auto) {
        this.setAttribute("autofocus", auto);
    }

    @Override
    public boolean getDisabled() {
        return this.getAttributeBoolean("disabled");
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.setAttribute("disabled", disabled);
    }

    @Override
    public HTMLFormElement getForm() {
        if (this.hasAttribute("form")) {
            String id = this.getAttribute("form");
            return (HTMLFormElement)this.getElementById(id);
        }
        return super.getForm();
    }

    @Override
    public boolean getMultiple() {
        return this.getAttributeBoolean("multiple");
    }

    @Override
    public void setMultiple(boolean b) {
        this.setAttribute("multiple", b);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public boolean getRequired() {
        return this.getAttributeBoolean("required");
    }

    @Override
    public void setRequired(boolean b) {
        this.setAttribute("required", b);
    }

    @Override
    public int getSize() {
        return this.getAttributeInt("size");
    }

    @Override
    public void setSize(int size) {
        this.setAttribute("size", size);
    }

    @Override
    public String getType() {
        boolean multiple = this.getAttributeBoolean("multiple");
        return multiple ? "select-multiple" : "select-one";
    }

    @Override
    public HTMLOptionsCollection getOptions() {
        return new HTMLOptionsCollectionImp(this);
    }

    @Override
    public int getLength() {
        return this.getOptions().getLength();
    }

    @Override
    public void setLength(int length) {
        this.getOptions().setLength(length);
    }

    @Override
    public HTMLOptionElement item(int index) {
        return this.getOptions().item(index);
    }

    @Override
    public HTMLOptionElement namedItem(String name) {
        return this.getOptions().namedItem(name);
    }

    @Override
    public void add(HTMLOptionElement option) {
        this.getOptions().add(option);
    }

    @Override
    public void add(HTMLOptionElement option, int before) {
        this.getOptions().add(option, before);
    }

    @Override
    public void add(HTMLOptionElement option, HTMLElement before) {
        this.getOptions().add(option, before);
    }

    @Override
    public void add(HTMLOptGroupElement group) {
        this.getOptions().add(group);
    }

    @Override
    public void add(HTMLOptGroupElement group, int before) {
        this.getOptions().add(group, before);
    }

    @Override
    public void add(HTMLOptGroupElement group, HTMLElement before) {
        this.getOptions().add(group, before);
    }

    @Override
    public void remove() {
        super.remove();
    }

    @Override
    public void remove(int index) {
        this.getOptions().remove(index);
    }

    @Override
    public HTMLCollection<HTMLOptionElement> getSelectedOptions() {
        HTMLCollectionImp<HTMLOptionElement> selected = new HTMLCollectionImp<HTMLOptionElement>();
        for (HTMLOptionElement o : this.getOptions()) {
            if (!o.getSelected()) continue;
            selected.add(o);
        }
        return selected;
    }

    @Override
    public int getSelectedIndex() {
        return this.getOptions().getSelectedIndex();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.getOptions().setSelectedIndex(index);
    }

    @Override
    public String getValue() {
        for (HTMLOptionElement option : this.getOptions()) {
            if (!option.getSelected()) continue;
            return option.getValue();
        }
        return "";
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            return;
        }
        HTMLOptionsCollection options = this.getOptions();
        for (HTMLOptionElement o : options) {
            boolean selected = value.equals(o.getValue());
            o.setSelected(selected);
        }
    }

    @Override
    public boolean getWillValidate() {
        throw new NotImplementedException();
    }

    @Override
    public ValidityState getValidity() {
        throw new NotImplementedException();
    }

    @Override
    public String getValidationMessage() {
        throw new NotImplementedException();
    }

    @Override
    public boolean checkValidity() {
        throw new NotImplementedException();
    }

    @Override
    public void setCustomValidity(String error) {
        throw new NotImplementedException();
    }
}

