/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.HTMLCollection;
import cat.inspiracio.dom.HTMLCollectionImp;
import cat.inspiracio.dom.HierarchyRequestError;
import cat.inspiracio.dom.IndexSizeError;
import cat.inspiracio.html.HTMLDocumentImp;
import cat.inspiracio.html.HTMLElementImp;
import cat.inspiracio.html.HTMLTableBodyElement;
import cat.inspiracio.html.HTMLTableCaptionElement;
import cat.inspiracio.html.HTMLTableElement;
import cat.inspiracio.html.HTMLTableFootElement;
import cat.inspiracio.html.HTMLTableHeadElement;
import cat.inspiracio.html.HTMLTableRowElement;
import cat.inspiracio.html.HTMLTableSectionElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class HTMLTableElementImp
extends HTMLElementImp
implements HTMLTableElement {
    private static final long serialVersionUID = -3013705892481191802L;

    HTMLTableElementImp(HTMLDocumentImp owner) {
        super(owner, "table");
    }

    @Override
    public HTMLTableElement cloneNode(boolean deep) {
        return (HTMLTableElement)super.cloneNode(deep);
    }

    @Override
    public HTMLTableCaptionElement getCaption() {
        return (HTMLTableCaptionElement)this.getElementByTagName("caption");
    }

    @Override
    public synchronized void setCaption(HTMLTableCaptionElement caption) {
        if (caption == null) {
            throw new HierarchyRequestError();
        }
        this.deleteCaption();
        this.prepend(caption);
    }

    @Override
    public synchronized HTMLTableCaptionElement createCaption() {
        HTMLTableCaptionElement caption = this.getCaption();
        if (caption != null) {
            return caption;
        }
        caption = this.createElement(HTMLTableCaptionElement.class);
        this.prepend(caption);
        return caption;
    }

    @Override
    public synchronized void deleteCaption() {
        HTMLTableCaptionElement caption = this.getCaption();
        if (caption != null) {
            this.removeChild(caption);
        }
    }

    @Override
    public HTMLTableSectionElement getTHead() {
        return (HTMLTableSectionElement)this.getElementByTagName("thead");
    }

    @Override
    public synchronized void setTHead(HTMLTableSectionElement head) {
        if (head == null) {
            throw new HierarchyRequestError();
        }
        this.deleteTHead();
        this.insertHead(head);
    }

    @Override
    public synchronized HTMLTableSectionElement createTHead() {
        HTMLTableSectionElement head = this.getTHead();
        if (head != null) {
            return head;
        }
        head = this.createElement(HTMLTableHeadElement.class);
        this.insertHead(head);
        return head;
    }

    @Override
    public synchronized void deleteTHead() {
        HTMLTableSectionElement head = this.getTHead();
        if (head != null) {
            this.removeChild(head);
        }
    }

    private void insertHead(HTMLTableSectionElement thead) {
        this.appendChild(thead);
    }

    @Override
    public HTMLTableSectionElement getTFoot() {
        return (HTMLTableSectionElement)this.getElementByTagName("tfoot");
    }

    @Override
    public synchronized void setTFoot(HTMLTableSectionElement foot) {
        if (foot == null) {
            throw new HierarchyRequestError();
        }
        this.deleteTFoot();
        this.insertFoot(foot);
    }

    @Override
    public synchronized HTMLTableSectionElement createTFoot() {
        HTMLTableSectionElement foot = this.getTFoot();
        if (foot != null) {
            return foot;
        }
        foot = this.createElement(HTMLTableFootElement.class);
        this.insertFoot(foot);
        return foot;
    }

    @Override
    public synchronized void deleteTFoot() {
        HTMLTableSectionElement foot = this.getTFoot();
        if (foot != null) {
            this.removeChild(foot);
        }
    }

    private void insertFoot(HTMLTableSectionElement foot) {
        this.appendChild(foot);
    }

    @Override
    public HTMLCollection<HTMLTableSectionElement> getTBodies() {
        HTMLCollectionImp<HTMLTableSectionElement> bodies = new HTMLCollectionImp<HTMLTableSectionElement>();
        NodeList nodes = this.getElementsByTagName("tbody");
        for (int i = 0; i < nodes.getLength(); ++i) {
            HTMLTableSectionElement e = (HTMLTableSectionElement)nodes.item(i);
            bodies.add(e);
        }
        return bodies;
    }

    @Override
    public synchronized HTMLTableSectionElement createTBody() {
        HTMLTableSectionElement body = this.createElement(HTMLTableBodyElement.class);
        this.insertBody(body);
        return body;
    }

    private void insertBody(HTMLTableSectionElement body) {
        this.appendChild(body);
    }

    @Override
    public HTMLCollection<HTMLTableRowElement> getRows() {
        HTMLCollectionImp<HTMLTableRowElement> rows = new HTMLCollectionImp<HTMLTableRowElement>();
        NodeList nodes = this.getElementsByTagName("tr");
        for (int i = 0; i < nodes.getLength(); ++i) {
            HTMLTableRowElement e = (HTMLTableRowElement)nodes.item(i);
            rows.add(e);
        }
        return rows;
    }

    @Override
    public HTMLTableRowElement insertRow() {
        return this.insertRow(-1);
    }

    @Override
    public synchronized HTMLTableRowElement insertRow(int index) {
        HTMLTableSectionElement body = null;
        HTMLCollection<HTMLTableSectionElement> bodies = this.getTBodies();
        body = bodies.getLength() == 0 ? this.createTBody() : bodies.item(0);
        HTMLCollection<HTMLTableRowElement> rows = body.getRows();
        if (index < -1 || rows.getLength() < index) {
            throw new IndexSizeError();
        }
        HTMLTableRowElement row = this.createElement(HTMLTableRowElement.class);
        HTMLTableRowElement before = index == -1 ? null : rows.item(index);
        body.insertBefore(row, before);
        return row;
    }

    @Override
    public synchronized void deleteRow(int index) {
        HTMLCollection<HTMLTableRowElement> rows = this.getRows();
        int length = rows.getLength();
        if (index == -1) {
            index = length - 1;
        }
        if (index <= 0 || length - 1 < index) {
            throw new IndexSizeError();
        }
        HTMLTableRowElement row = rows.item(index);
        Node parent = row.getParentNode();
        parent.removeChild(row);
    }

    @Override
    public String getBorder() {
        return this.getAttribute("border");
    }

    @Override
    public void setBorder(String border) {
        this.setAttribute("border", border);
    }
}

