/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.HTMLCollection;
import cat.inspiracio.dom.HTMLCollectionImp;
import cat.inspiracio.dom.IndexSizeError;
import cat.inspiracio.html.HTMLDocumentImp;
import cat.inspiracio.html.HTMLElement;
import cat.inspiracio.html.HTMLElementImp;
import cat.inspiracio.html.HTMLTableCellElement;
import cat.inspiracio.html.HTMLTableDataCellElement;
import cat.inspiracio.html.HTMLTableElement;
import cat.inspiracio.html.HTMLTableRowElement;
import cat.inspiracio.html.HTMLTableSectionElement;
import org.w3c.dom.Node;

class HTMLTableRowElementImp
extends HTMLElementImp
implements HTMLTableRowElement {
    private static final long serialVersionUID = 1204236995788001549L;

    HTMLTableRowElementImp(HTMLDocumentImp owner) {
        super(owner, "tr");
    }

    @Override
    public HTMLTableRowElement cloneNode(boolean deep) {
        return (HTMLTableRowElement)super.cloneNode(deep);
    }

    @Override
    public int getRowIndex() {
        HTMLTableElement table = this.getTable();
        if (table == null) {
            return -1;
        }
        HTMLCollection<HTMLTableRowElement> rows = table.getRows();
        for (int i = 0; i < rows.getLength(); ++i) {
            if (this != rows.item(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getSectionRowIndex() {
        Node parent = this.getParentNode();
        if (parent == null) {
            return -1;
        }
        HTMLCollection<HTMLTableRowElement> rows = null;
        if (parent instanceof HTMLTableElement) {
            HTMLTableElement table = (HTMLTableElement)parent;
            rows = table.getRows();
        } else if (parent instanceof HTMLTableSectionElement) {
            HTMLTableSectionElement section = (HTMLTableSectionElement)parent;
            rows = section.getRows();
        }
        if (rows == null) {
            return -1;
        }
        for (int i = 0; i < rows.getLength(); ++i) {
            if (this != rows.item(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public HTMLCollection<HTMLTableCellElement> getCells() {
        HTMLCollectionImp<HTMLTableCellElement> cells = new HTMLCollectionImp<HTMLTableCellElement>();
        HTMLCollection<HTMLElement> children = this.getChildElements();
        for (HTMLElement e : children) {
            if (!(e instanceof HTMLTableCellElement)) continue;
            cells.add((HTMLTableCellElement)e);
        }
        return cells;
    }

    @Override
    public HTMLTableCellElement insertCell() {
        return this.insertCell(-1);
    }

    @Override
    public HTMLTableCellElement insertCell(int index) {
        HTMLCollection<HTMLTableCellElement> cells = this.getCells();
        if (index < -1 || cells.getLength() < index) {
            throw new IndexSizeError();
        }
        HTMLTableDataCellElement td = this.createElement(HTMLTableDataCellElement.class);
        HTMLTableCellElement before = index == -1 ? null : cells.item(index);
        this.insertBefore(td, before);
        return td;
    }

    @Override
    public void deleteCell(int index) {
        HTMLCollection<HTMLTableCellElement> cells = this.getCells();
        if (index < 0 || cells.getLength() <= index) {
            throw new IndexSizeError();
        }
        HTMLTableCellElement cell = cells.item(index);
        Node parent = cell.getParentNode();
        if (parent != null) {
            parent.removeChild(cell);
        }
    }

    private HTMLTableElement getTable() {
        for (Node parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof HTMLTableElement)) continue;
            return (HTMLTableElement)parent;
        }
        return null;
    }
}

