/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.html;

import cat.inspiracio.dom.HTMLCollection;
import cat.inspiracio.dom.HTMLCollectionImp;
import cat.inspiracio.dom.IndexSizeError;
import cat.inspiracio.html.HTMLDocumentImp;
import cat.inspiracio.html.HTMLElement;
import cat.inspiracio.html.HTMLElementImp;
import cat.inspiracio.html.HTMLTableRowElement;
import cat.inspiracio.html.HTMLTableSectionElement;
import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class HTMLTableSectionElementImp
extends HTMLElementImp
implements HTMLTableSectionElement {
    private static final long serialVersionUID = -7878825993239107440L;

    HTMLTableSectionElementImp(HTMLDocumentImp owner, String tag) {
        super(owner, tag);
    }

    @Override
    public HTMLTableSectionElement cloneNode(boolean deep) {
        return (HTMLTableSectionElement)super.cloneNode(deep);
    }

    @Override
    public HTMLCollection<HTMLTableRowElement> getRows() {
        HTMLCollectionImp<HTMLTableRowElement> rows = new HTMLCollectionImp<HTMLTableRowElement>();
        NodeList nodes = this.getElementsByTagName("tr");
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            HTMLElement e = (HTMLElement)iterator.next();
            rows.add((HTMLTableRowElement)e);
        }
        return rows;
    }

    @Override
    public HTMLTableRowElement insertRow() {
        return this.insertRow(-1);
    }

    @Override
    public HTMLTableRowElement insertRow(int index) {
        HTMLCollection<HTMLTableRowElement> rows = this.getRows();
        if (index < -1 || rows.getLength() < index) {
            throw new IndexSizeError();
        }
        HTMLTableRowElement row = this.createElement(HTMLTableRowElement.class);
        HTMLTableRowElement before = index == -1 ? null : rows.item(index);
        this.insertBefore(row, before);
        return row;
    }

    @Override
    public void deleteRow(int index) {
        HTMLCollection<HTMLTableRowElement> rows = this.getRows();
        int length = rows.getLength();
        if (index == -1) {
            index = length - 1;
        }
        if (index <= 0 || length - 1 < index) {
            throw new IndexSizeError();
        }
        HTMLTableRowElement row = rows.item(index);
        Node parent = row.getParentNode();
        parent.removeChild(row);
    }
}

