/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.app.config;

import cd.connect.app.config.ConfigKey;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.stickycode.bootstrap.ComponentContainer;
import net.stickycode.coercion.Coercion;
import net.stickycode.coercion.CoercionFinder;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.coercion.target.CoercionTargets;
import net.stickycode.configuration.ConfigurationKey;
import net.stickycode.configuration.ResolvedConfiguration;
import net.stickycode.configured.ConfigurationAttribute;
import net.stickycode.configured.ConfigurationRepository;
import net.stickycode.configured.ConfiguredFieldsMustNotBePrimitiveAsDefaultDerivationIsImpossibleException;
import net.stickycode.configured.MissingConfigurationException;
import net.stickycode.reflector.AnnotatedFieldProcessor;
import net.stickycode.reflector.Fields;

public class ConfigKeyProcessor
extends AnnotatedFieldProcessor {
    private final ConfigurationRepository configuration;

    public ConfigKeyProcessor(ConfigurationRepository configuration) {
        super(new Class[]{ConfigKey.class});
        this.configuration = configuration;
    }

    public void processField(final Object target, final Field field) {
        if (field.getType().isPrimitive()) {
            throw new ConfiguredFieldsMustNotBePrimitiveAsDefaultDerivationIsImpossibleException(target, field);
        }
        this.configuration.register(new ConfigurationAttribute(){
            private CoercionTarget coercionTarget;
            private ResolvedConfiguration resolution;
            private Object value;
            private Coercion<Object> coercion;
            private Object defaultValue;
            {
                this.coercionTarget = CoercionTargets.find((Field)field);
                this.defaultValue = Fields.get((Object)target, (Field)field);
            }

            public void applyCoercion(CoercionFinder coercions) {
                this.coercion = coercions.find(this.coercionTarget);
                this.value = this.resolveValue();
            }

            private Object resolveValue() {
                if (this.resolution.hasValue()) {
                    return this.coercion.coerce(this.coercionTarget, this.resolution.getValue());
                }
                if (this.coercion.hasDefaultValue()) {
                    return this.coercion.getDefaultValue(this.coercionTarget);
                }
                return null;
            }

            public void update() {
                if (this.value != null) {
                    Fields.set((Object)target, (Field)field, (Object)this.value);
                } else if (this.defaultValue == null) {
                    throw new MissingConfigurationException((ConfigurationKey)this, this.resolution);
                }
            }

            public void invertControl(ComponentContainer container) {
                if (this.value != null) {
                    container.inject(this.value);
                }
            }

            public boolean requiresResolution() {
                return true;
            }

            public ResolvedConfiguration getResolution() {
                return this.resolution;
            }

            public String toString() {
                return String.join((CharSequence)",", this.join("."));
            }

            public Object getTarget() {
                return target;
            }

            public void resolvedWith(ResolvedConfiguration resolved) {
                this.resolution = resolved;
            }

            public CoercionTarget getCoercionTarget() {
                return this.coercionTarget;
            }

            public List<String> join(String delimeter) {
                ConfigKey key = field.getAnnotation(ConfigKey.class);
                if (key != null) {
                    if (key.value() != null && key.value().length() > 0) {
                        return Collections.singletonList(key.value());
                    }
                    if (target != null) {
                        return Collections.singletonList(this.getSimpleName(delimeter));
                    }
                }
                return new ArrayList<String>();
            }

            private String getSimpleName(String delimeter) {
                return target.getClass().getSimpleName().substring(0, 1).toLowerCase() + target.getClass().getSimpleName().substring(1) + delimeter + field.getName();
            }
        });
    }
}

