/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.app.config;

import cd.connect.app.config.ConfigKeyProcessor;
import cd.connect.app.config.MapCoercion;
import cd.connect.app.config.SystemPropertiesConfigurationSource;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Set;
import net.stickycode.coercion.CoercionFinder;
import net.stickycode.coercion.Coercions;
import net.stickycode.configuration.ConfigurationTarget;
import net.stickycode.configuration.StickyConfiguration;
import net.stickycode.configured.Configuration;
import net.stickycode.configured.ConfigurationAttribute;
import net.stickycode.configured.ConfigurationRepository;
import net.stickycode.configured.InlineConfigurationRepository;
import net.stickycode.configured.TriedToInvertAnInvertedValue;
import net.stickycode.reflector.FieldProcessor;
import net.stickycode.reflector.Reflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeclaredConfigResolver {
    private static final Logger log = LoggerFactory.getLogger(DeclaredConfigResolver.class);
    private static DeclaredConfigResolver instance = new DeclaredConfigResolver();
    private StickyConfiguration resolver = new StickyConfiguration();
    private Coercions coercions = new Coercions();
    private ConfigurationRepository configurations = new InlineConfigurationRepository();

    private DeclaredConfigResolver() {
        Set<MapCoercion> extensions = Collections.singleton(new MapCoercion((CoercionFinder)this.coercions));
        DeclaredConfigResolver.setInstanceValue(this.coercions, "extensions", extensions);
        Set<SystemPropertiesConfigurationSource> configSources = Collections.singleton(new SystemPropertiesConfigurationSource());
        DeclaredConfigResolver.setInstanceValue(this.resolver, "sources", configSources);
        this.resolver.startup();
    }

    private static void setInstanceValue(Object classInstance, String fieldName, Object newValue) {
        try {
            Field field = classInstance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(classInstance, newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void resolveBean(Object bean) {
        new Reflector().forEachField(new FieldProcessor[]{new ConfigKeyProcessor(this.configurations)}).process(bean);
        log.debug("starting resolution - pass 1");
        for (Configuration configuration : this.configurations) {
            this.resolveAttributes(bean, configuration);
        }
        log.debug("starting resolution - pass 2");
        for (Configuration configuration : this.configurations) {
            for (ConfigurationAttribute attribute : configuration) {
                if (!attribute.requiresResolution()) continue;
                log.debug("resolve second pass {}", (Object)attribute);
                this.resolver.resolve((ConfigurationTarget)attribute);
                attribute.applyCoercion((CoercionFinder)this.coercions);
            }
        }
    }

    private void resolveAttributes(Object target, Configuration configuration) {
        log.debug("resolve {}", (Object)configuration);
        try {
            for (ConfigurationAttribute attribute : configuration) {
                this.resolveAttribute(target, attribute);
            }
        }
        catch (ConcurrentModificationException e) {
            throw new TriedToInvertAnInvertedValue(configuration);
        }
    }

    private void resolveAttribute(Object target, ConfigurationAttribute attribute) {
        if (attribute.requiresResolution() && attribute.getTarget() == target) {
            log.debug("resolve {}", (Object)attribute);
            this.resolver.resolve((ConfigurationTarget)attribute);
            attribute.applyCoercion((CoercionFinder)this.coercions);
            attribute.update();
        }
    }

    public static void resolve(Object bean) {
        instance.resolveBean(bean);
    }
}

