/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.app.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.stickycode.coercion.AbstractNoDefaultCoercion;
import net.stickycode.coercion.Coercion;
import net.stickycode.coercion.CoercionFinder;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.coercion.StringSpliterable;

public class MapCoercion
extends AbstractNoDefaultCoercion<Map<Object, Object>> {
    private final CoercionFinder finder;

    public MapCoercion(CoercionFinder finder) {
        this.finder = finder;
    }

    public Map<Object, Object> coerce(CoercionTarget type, String value) {
        if (value.length() == 0) {
            return Collections.emptyMap();
        }
        CoercionTarget[] typeArguments = type.getComponentCoercionTypes();
        assert (typeArguments.length == 2) : "Maps should have two type arguments";
        Coercion<?> keyCoercion = this.findComponentCoercion(typeArguments[0]);
        Coercion<?> valueCoercion = this.findComponentCoercion(typeArguments[1]);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (String string : new StringSpliterable(value)) {
            String[] s = string.split("=");
            map.put(keyCoercion.coerce(typeArguments[0], s[0].trim()), valueCoercion.coerce(typeArguments[1], s[1].trim()));
        }
        return Collections.unmodifiableMap(map);
    }

    private Coercion<?> findComponentCoercion(CoercionTarget target) {
        return this.finder.find(target);
    }

    public boolean isApplicableTo(CoercionTarget target) {
        return Map.class.isAssignableFrom(target.getType());
    }
}

