/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.jersey.prometheus;

import cd.connect.jersey.prometheus.GlobalJerseyMetrics;
import cd.connect.jersey.prometheus.Prometheus;
import io.prometheus.client.Histogram;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

@Priority(value=3000)
public class PrometheusFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String TRACKER_TIMER = "prometheus.timer";
    protected final ResourceInfo resourceInfo;
    protected String prefix = "";
    private final Prometheus annotation;
    private Histogram tracker;

    public PrometheusFilter(ResourceInfo resourceInfo, String prefix, Prometheus annotation) {
        this.resourceInfo = resourceInfo;
        this.prefix = prefix;
        this.annotation = annotation;
        this.buildTimerFromAnnotation(annotation);
    }

    private void buildTimerFromAnnotation(Prometheus annotation) {
        if (annotation != null && annotation.help().length() > 0 && annotation.name().length() > 0) {
            this.tracker = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(annotation.name())).help(annotation.help())).register();
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.tracker == null) {
            this.buildTracker(requestContext);
        }
        if (this.tracker != null) {
            Histogram.Timer timer = this.tracker.startTimer();
            requestContext.setProperty(TRACKER_TIMER, (Object)timer);
        }
    }

    private void buildTracker(ContainerRequestContext requestContext) {
        String name;
        String path;
        String string = path = this.annotation == null ? "" : this.annotation.help();
        if (path.length() == 0) {
            MultivaluedMap pathParameters = requestContext.getUriInfo().getPathParameters();
            path = PrometheusFilter.path(requestContext.getUriInfo().getRequestUri());
            for (Map.Entry entry : pathParameters.entrySet()) {
                String originalPathFragment = String.format("{%s}", entry.getKey());
                for (String currentPathFragment : (List)entry.getValue()) {
                    path = path.replace(currentPathFragment, originalPathFragment);
                }
            }
        }
        String string2 = name = this.annotation == null ? "" : this.annotation.name();
        if (name.length() == 0) {
            name = this.resourceInfo.getResourceMethod().getName();
        }
        if (this.prefix != null && this.prefix.length() > 0) {
            name = this.prefix + "_" + name;
        }
        this.tracker = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(name)).help(path)).register();
    }

    public static String path(URI uri) {
        String path = uri.getPath();
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Histogram.Timer timer = (Histogram.Timer)Histogram.Timer.class.cast(requestContext.getProperty(TRACKER_TIMER));
        if (timer != null) {
            timer.observeDuration();
        }
        if (responseContext.getStatus() >= 500) {
            GlobalJerseyMetrics.response_5xx.inc();
        } else if (responseContext.getStatus() >= 400) {
            GlobalJerseyMetrics.response_4xx.inc();
        } else if (responseContext.getStatus() >= 300) {
            GlobalJerseyMetrics.response_3xx.inc();
        } else if (responseContext.getStatus() >= 200) {
            GlobalJerseyMetrics.response_2xx.inc();
        }
    }

    private static class PrometheusHistogramListener
    implements RequestEventListener {
        private static ConcurrentHashMap<String, Histogram> histograms = new ConcurrentHashMap();
        private static ConcurrentHashMap<Method, Method> ignored = new ConcurrentHashMap();
        private Histogram.Timer timer;
        private final String prefix;

        private PrometheusHistogramListener(String prefix) {
            this.prefix = prefix;
        }

        private void resourceStart(RequestEvent matched) {
            Method method = matched.getUriInfo().getMatchedResourceMethod().getInvocable().getHandlingMethod();
            if (ignored.get(method) != null) {
                return;
            }
            Prometheus instrument = method.getAnnotation(Prometheus.class);
            if (instrument != null) {
                Histogram tracker = histograms.get(instrument.name());
                if (tracker == null) {
                    tracker = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(this.prefix + instrument.name())).help(instrument.help())).register();
                    histograms.put(instrument.name(), tracker);
                }
                this.timer = tracker.startTimer();
                GlobalJerseyMetrics.requests.inc();
            } else {
                ignored.put(method, method);
            }
        }

        public void onEvent(RequestEvent matched) {
            if (matched.getType() == RequestEvent.Type.RESOURCE_METHOD_START) {
                this.resourceStart(matched);
            } else if (matched.getType() == RequestEvent.Type.RESOURCE_METHOD_FINISHED && this.timer != null) {
                this.timer.observeDuration();
                this.timer = null;
            }
        }
    }
}

