/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.jersey.prometheus;

import cd.connect.jersey.prometheus.GlobalJerseyMetrics;
import cd.connect.jersey.prometheus.Prometheus;
import cd.connect.jersey.prometheus.PrometheusFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class PrometheusDynamicFeature
implements DynamicFeature {
    private final boolean profileAll;
    private final String prefix = System.getProperty("prometheus.jersey.prefix", System.getenv("PROMETHEUS_JERSEY_PREFIX"));

    public PrometheusDynamicFeature() {
        this(PrometheusDynamicFeature.profileAll());
    }

    private static boolean profileAll() {
        String val = System.getProperty("prometheus.jersey.all", System.getenv("PROMETHEUS_JERSEY_ALL"));
        return val == null ? true : Boolean.valueOf(val);
    }

    public PrometheusDynamicFeature(boolean profileAll) {
        GlobalJerseyMetrics.init(this.prefix);
        this.profileAll = profileAll;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Prometheus annotation = resourceInfo.getResourceMethod().getAnnotation(Prometheus.class);
        if (annotation != null || this.profileAll) {
            context.register((Object)new PrometheusFilter(resourceInfo, this.prefix, annotation));
        }
    }
}

