/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import javax.servlet.ServletContext;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.security.authentication.util.ZKSignerSecretProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestZKSignerSecretProvider {
    private TestingServer zkServer;

    @Before
    public void setup() throws Exception {
        this.zkServer = new TestingServer();
    }

    @After
    public void teardown() throws Exception {
        if (this.zkServer != null) {
            this.zkServer.stop();
            this.zkServer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOne() throws Exception {
        long rolloverFrequency = 15000L;
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        byte[] secret2 = Long.toString(rand.nextLong()).getBytes();
        byte[] secret1 = Long.toString(rand.nextLong()).getBytes();
        byte[] secret3 = Long.toString(rand.nextLong()).getBytes();
        ZKSignerSecretProvider secretProvider = new ZKSignerSecretProvider(seed);
        Properties config = new Properties();
        config.setProperty("signer.secret.provider.zookeeper.connection.string", this.zkServer.getConnectString());
        config.setProperty("signer.secret.provider.zookeeper.path", "/secret");
        try {
            secretProvider.init(config, this.getDummyServletContext(), rolloverFrequency);
            byte[] currentSecret = secretProvider.getCurrentSecret();
            byte[][] allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret1, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[0]);
            Assert.assertNull((Object)allSecrets[1]);
            Thread.sleep(rolloverFrequency + 2000L);
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret2, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[1]);
            Thread.sleep(rolloverFrequency + 2000L);
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret3, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret3, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[1]);
            Thread.sleep(rolloverFrequency + 2000L);
        }
        finally {
            secretProvider.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleInit() throws Exception {
        long rolloverFrequency = 15000L;
        long seedA = System.currentTimeMillis();
        Random rand = new Random(seedA);
        byte[] secretA2 = Long.toString(rand.nextLong()).getBytes();
        byte[] secretA1 = Long.toString(rand.nextLong()).getBytes();
        long seedB = System.currentTimeMillis() + rand.nextLong();
        rand = new Random(seedB);
        byte[] secretB2 = Long.toString(rand.nextLong()).getBytes();
        byte[] secretB1 = Long.toString(rand.nextLong()).getBytes();
        long seedC = System.currentTimeMillis() + rand.nextLong();
        rand = new Random(seedC);
        byte[] secretC2 = Long.toString(rand.nextLong()).getBytes();
        byte[] secretC1 = Long.toString(rand.nextLong()).getBytes();
        ZKSignerSecretProvider secretProviderA = new ZKSignerSecretProvider(seedA);
        ZKSignerSecretProvider secretProviderB = new ZKSignerSecretProvider(seedB);
        ZKSignerSecretProvider secretProviderC = new ZKSignerSecretProvider(seedC);
        Properties config = new Properties();
        config.setProperty("signer.secret.provider.zookeeper.connection.string", this.zkServer.getConnectString());
        config.setProperty("signer.secret.provider.zookeeper.path", "/secret");
        try {
            secretProviderA.init(config, this.getDummyServletContext(), rolloverFrequency);
            secretProviderB.init(config, this.getDummyServletContext(), rolloverFrequency);
            secretProviderC.init(config, this.getDummyServletContext(), rolloverFrequency);
            byte[] currentSecretA = secretProviderA.getCurrentSecret();
            byte[][] allSecretsA = secretProviderA.getAllSecrets();
            byte[] currentSecretB = secretProviderB.getCurrentSecret();
            byte[][] allSecretsB = secretProviderB.getAllSecrets();
            byte[] currentSecretC = secretProviderC.getCurrentSecret();
            byte[][] allSecretsC = secretProviderC.getAllSecrets();
            Assert.assertArrayEquals((byte[])currentSecretA, (byte[])currentSecretB);
            Assert.assertArrayEquals((byte[])currentSecretB, (byte[])currentSecretC);
            Assert.assertEquals((long)2L, (long)allSecretsA.length);
            Assert.assertEquals((long)2L, (long)allSecretsB.length);
            Assert.assertEquals((long)2L, (long)allSecretsC.length);
            Assert.assertArrayEquals((byte[])allSecretsA[0], (byte[])allSecretsB[0]);
            Assert.assertArrayEquals((byte[])allSecretsB[0], (byte[])allSecretsC[0]);
            Assert.assertNull((Object)allSecretsA[1]);
            Assert.assertNull((Object)allSecretsB[1]);
            Assert.assertNull((Object)allSecretsC[1]);
            int secretChosen = 122;
            if (Arrays.equals(secretA1, currentSecretA)) {
                Assert.assertArrayEquals((byte[])secretA1, (byte[])allSecretsA[0]);
                secretChosen = 65;
            } else if (Arrays.equals(secretB1, currentSecretB)) {
                Assert.assertArrayEquals((byte[])secretB1, (byte[])allSecretsA[0]);
                secretChosen = 66;
            } else if (Arrays.equals(secretC1, currentSecretC)) {
                Assert.assertArrayEquals((byte[])secretC1, (byte[])allSecretsA[0]);
                secretChosen = 67;
            } else {
                Assert.fail((String)"It appears that they all agreed on the same secret, but not one of the secrets they were supposed to");
            }
            Thread.sleep(rolloverFrequency + 2000L);
            currentSecretA = secretProviderA.getCurrentSecret();
            allSecretsA = secretProviderA.getAllSecrets();
            currentSecretB = secretProviderB.getCurrentSecret();
            allSecretsB = secretProviderB.getAllSecrets();
            currentSecretC = secretProviderC.getCurrentSecret();
            allSecretsC = secretProviderC.getAllSecrets();
            Assert.assertArrayEquals((byte[])currentSecretA, (byte[])currentSecretB);
            Assert.assertArrayEquals((byte[])currentSecretB, (byte[])currentSecretC);
            Assert.assertEquals((long)2L, (long)allSecretsA.length);
            Assert.assertEquals((long)2L, (long)allSecretsB.length);
            Assert.assertEquals((long)2L, (long)allSecretsC.length);
            Assert.assertArrayEquals((byte[])allSecretsA[0], (byte[])allSecretsB[0]);
            Assert.assertArrayEquals((byte[])allSecretsB[0], (byte[])allSecretsC[0]);
            Assert.assertArrayEquals((byte[])allSecretsA[1], (byte[])allSecretsB[1]);
            Assert.assertArrayEquals((byte[])allSecretsB[1], (byte[])allSecretsC[1]);
            if (secretChosen == 65) {
                Assert.assertArrayEquals((byte[])secretA2, (byte[])currentSecretA);
            } else if (secretChosen == 66) {
                Assert.assertArrayEquals((byte[])secretB2, (byte[])currentSecretA);
            } else if (secretChosen == 67) {
                Assert.assertArrayEquals((byte[])secretC2, (byte[])currentSecretA);
            }
        }
        finally {
            secretProviderC.destroy();
            secretProviderB.destroy();
            secretProviderA.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleUnsychnronized() throws Exception {
        long rolloverFrequency = 15000L;
        long seedA = System.currentTimeMillis();
        Random rand = new Random(seedA);
        byte[] secretA2 = Long.toString(rand.nextLong()).getBytes();
        byte[] secretA1 = Long.toString(rand.nextLong()).getBytes();
        byte[] secretA3 = Long.toString(rand.nextLong()).getBytes();
        long seedB = System.currentTimeMillis() + rand.nextLong();
        rand = new Random(seedB);
        byte[] secretB2 = Long.toString(rand.nextLong()).getBytes();
        byte[] secretB1 = Long.toString(rand.nextLong()).getBytes();
        byte[] secretB3 = Long.toString(rand.nextLong()).getBytes();
        ZKSignerSecretProvider secretProviderA = new ZKSignerSecretProvider(seedA);
        ZKSignerSecretProvider secretProviderB = new ZKSignerSecretProvider(seedB);
        Properties config = new Properties();
        config.setProperty("signer.secret.provider.zookeeper.connection.string", this.zkServer.getConnectString());
        config.setProperty("signer.secret.provider.zookeeper.path", "/secret");
        try {
            secretProviderA.init(config, this.getDummyServletContext(), rolloverFrequency);
            byte[] currentSecretA = secretProviderA.getCurrentSecret();
            byte[][] allSecretsA = secretProviderA.getAllSecrets();
            Assert.assertArrayEquals((byte[])secretA1, (byte[])currentSecretA);
            Assert.assertEquals((long)2L, (long)allSecretsA.length);
            Assert.assertArrayEquals((byte[])secretA1, (byte[])allSecretsA[0]);
            Assert.assertNull((Object)allSecretsA[1]);
            Thread.sleep(rolloverFrequency + 2000L);
            currentSecretA = secretProviderA.getCurrentSecret();
            allSecretsA = secretProviderA.getAllSecrets();
            Assert.assertArrayEquals((byte[])secretA2, (byte[])currentSecretA);
            Assert.assertEquals((long)2L, (long)allSecretsA.length);
            Assert.assertArrayEquals((byte[])secretA2, (byte[])allSecretsA[0]);
            Assert.assertArrayEquals((byte[])secretA1, (byte[])allSecretsA[1]);
            Thread.sleep(rolloverFrequency / 5L);
            secretProviderB.init(config, this.getDummyServletContext(), rolloverFrequency);
            byte[] currentSecretB = secretProviderB.getCurrentSecret();
            byte[][] allSecretsB = secretProviderB.getAllSecrets();
            Assert.assertArrayEquals((byte[])secretA2, (byte[])currentSecretB);
            Assert.assertEquals((long)2L, (long)allSecretsA.length);
            Assert.assertArrayEquals((byte[])secretA2, (byte[])allSecretsB[0]);
            Assert.assertArrayEquals((byte[])secretA1, (byte[])allSecretsB[1]);
            Thread.sleep(rolloverFrequency);
            currentSecretA = secretProviderA.getCurrentSecret();
            allSecretsA = secretProviderA.getAllSecrets();
            currentSecretB = secretProviderB.getCurrentSecret();
            allSecretsB = secretProviderB.getAllSecrets();
            Assert.assertArrayEquals((byte[])currentSecretA, (byte[])currentSecretB);
            Assert.assertEquals((long)2L, (long)allSecretsA.length);
            Assert.assertEquals((long)2L, (long)allSecretsB.length);
            Assert.assertArrayEquals((byte[])allSecretsA[0], (byte[])allSecretsB[0]);
            Assert.assertArrayEquals((byte[])allSecretsA[1], (byte[])allSecretsB[1]);
            if (Arrays.equals(secretA3, currentSecretA)) {
                Assert.assertArrayEquals((byte[])secretA3, (byte[])allSecretsA[0]);
            } else if (Arrays.equals(secretB3, currentSecretB)) {
                Assert.assertArrayEquals((byte[])secretB3, (byte[])allSecretsA[0]);
            } else {
                Assert.fail((String)"It appears that they all agreed on the same secret, but not one of the secrets they were supposed to");
            }
        }
        finally {
            secretProviderB.destroy();
            secretProviderA.destroy();
        }
    }

    private ServletContext getDummyServletContext() {
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getAttribute("signer.secret.provider.zookeeper.curator.client")).thenReturn(null);
        return servletContext;
    }
}

