/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.authentication.client.PseudoAuthenticator;
import org.apache.hadoop.security.authentication.util.AuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticator
implements Authenticator {
    private static Logger LOG = LoggerFactory.getLogger(KerberosAuthenticator.class);
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String NEGOTIATE = "Negotiate";
    private static final String AUTH_HTTP_METHOD = "OPTIONS";
    private URL url;
    private HttpURLConnection conn;
    private Base64 base64;
    private ConnectionConfigurator connConfigurator;

    public void setConnectionConfigurator(ConnectionConfigurator configurator) {
        this.connConfigurator = configurator;
    }

    public void authenticate(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        if (!token.isSet()) {
            this.url = url;
            this.base64 = new Base64(0);
            this.conn = (HttpURLConnection)url.openConnection();
            if (this.connConfigurator != null) {
                this.conn = this.connConfigurator.configure(this.conn);
            }
            this.conn.setRequestMethod(AUTH_HTTP_METHOD);
            this.conn.connect();
            boolean needFallback = false;
            if (this.conn.getResponseCode() == 200) {
                LOG.debug("JDK performed authentication on our behalf.");
                AuthenticatedURL.extractToken((HttpURLConnection)this.conn, (AuthenticatedURL.Token)token);
                if (this.isTokenKerberos(token)) {
                    return;
                }
                needFallback = true;
            }
            if (!needFallback && this.isNegotiate()) {
                LOG.debug("Performing our own SPNEGO sequence.");
                this.doSpnegoSequence(token);
            } else {
                LOG.debug("Using fallback authenticator sequence.");
                Authenticator auth = this.getFallBackAuthenticator();
                auth.setConnectionConfigurator(this.connConfigurator);
                auth.authenticate(url, token);
            }
        }
    }

    protected Authenticator getFallBackAuthenticator() {
        PseudoAuthenticator auth = new PseudoAuthenticator();
        if (this.connConfigurator != null) {
            auth.setConnectionConfigurator(this.connConfigurator);
        }
        return auth;
    }

    private boolean isTokenKerberos(AuthenticatedURL.Token token) throws AuthenticationException {
        AuthToken aToken;
        return token.isSet() && ((aToken = AuthToken.parse((String)token.toString())).getType().equals("kerberos") || aToken.getType().equals("kerberos-dt"));
    }

    private boolean isNegotiate() throws IOException {
        boolean negotiate = false;
        if (this.conn.getResponseCode() == 401) {
            String authHeader = this.conn.getHeaderField(WWW_AUTHENTICATE);
            negotiate = authHeader != null && authHeader.trim().startsWith(NEGOTIATE);
        }
        return negotiate;
    }

    private void doSpnegoSequence(AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        try {
            AccessControlContext context = AccessController.getContext();
            Subject subject = Subject.getSubject(context);
            if (subject == null || subject.getPrivateCredentials(KerberosKey.class).isEmpty() && subject.getPrivateCredentials(KerberosTicket.class).isEmpty()) {
                LOG.debug("No subject in context, logging in");
                subject = new Subject();
                LoginContext login = new LoginContext("", subject, null, (Configuration)new KerberosConfiguration(null));
                login.login();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using subject: " + subject);
            }
            Subject.doAs(subject, new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException ex) {
            if (ex.getException() instanceof IOException) {
                throw (IOException)ex.getException();
            }
            throw new AuthenticationException((Throwable)ex.getException());
        }
        catch (LoginException ex) {
            throw new AuthenticationException((Throwable)ex);
        }
        AuthenticatedURL.extractToken((HttpURLConnection)this.conn, (AuthenticatedURL.Token)token);
    }

    private void sendToken(byte[] outToken) throws IOException {
        String token = this.base64.encodeToString(outToken);
        this.conn = (HttpURLConnection)this.url.openConnection();
        if (this.connConfigurator != null) {
            this.conn = this.connConfigurator.configure(this.conn);
        }
        this.conn.setRequestMethod(AUTH_HTTP_METHOD);
        this.conn.setRequestProperty(AUTHORIZATION, "Negotiate " + token);
        this.conn.connect();
    }

    private byte[] readToken() throws IOException, AuthenticationException {
        int status = this.conn.getResponseCode();
        if (status == 200 || status == 401) {
            String authHeader = this.conn.getHeaderField(WWW_AUTHENTICATE);
            if (authHeader == null || !authHeader.trim().startsWith(NEGOTIATE)) {
                throw new AuthenticationException("Invalid SPNEGO sequence, 'WWW-Authenticate' header incorrect: " + authHeader);
            }
            String negotiation = authHeader.trim().substring("Negotiate ".length()).trim();
            return this.base64.decode(negotiation);
        }
        throw new AuthenticationException("Invalid SPNEGO sequence, status code: " + status);
    }

    static /* synthetic */ URL access$100(KerberosAuthenticator x0) {
        return x0.url;
    }

    static /* synthetic */ void access$200(KerberosAuthenticator x0, byte[] x1) throws IOException {
        x0.sendToken(x1);
    }

    static /* synthetic */ byte[] access$300(KerberosAuthenticator x0) throws IOException, AuthenticationException {
        return x0.readToken();
    }
}

