/*
 * Decompiled with CFR 0.152.
 */
package bloop.integrations.maven;

import bloop.integrations.maven.MojoImplementation;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import scala_maven.AppLauncher;
import scala_maven.ExtendedScalaContinuousCompileMojo;

@Mojo(name="bloop", threadSafe=true, requiresProject=true, defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.TEST)
public class BloopMojo
extends ExtendedScalaContinuousCompileMojo {
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Component
    private MavenPluginManager mavenPluginManager;
    @Parameter(property="bloop.configDirectory", defaultValue="${session.executionRootDirectory}/.bloop-config")
    private File bloopConfigDir;
    @Parameter(property="scala.artifactID", defaultValue="scala-compiler")
    private String scalaArtifactID;
    @Parameter(property="launcher")
    private String launcher;
    @Parameter(property="addRunArgs", name="addRunArgs")
    private String addRunArgs;
    @Parameter(property="bloop.executionFork", defaultValue="false")
    private boolean bloopExecutionFork;
    @Parameter
    private AppLauncher[] launchers;
    protected String mainClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        BloopMojo bloopMojo = MojoImplementation.initializeMojo(this.project, this.session, this.mojoExecution, this.mavenPluginManager, this.encoding);
        MojoImplementation.writeCompileAndTestConfiguration(bloopMojo, this.getLog());
    }

    public File[] getAllScalaJars() throws Exception {
        File file = this.getLibraryJar();
        File file2 = this.getCompilerJar();
        Object[] objectArray = new File[]{file, file2};
        List list = this.getCompilerDependencies();
        list.remove(file);
        return (File[])ArrayUtils.addAll((Object[])objectArray, (Object[])list.toArray());
    }

    public File getBloopConfigDir() {
        return this.bloopConfigDir;
    }

    public String getScalaArtifactID() {
        return this.scalaArtifactID;
    }

    public String getLauncher() {
        if (this.launcher == null) {
            return "";
        }
        return this.launcher;
    }

    public String getAddRunArgs() {
        if (this.addRunArgs == null) {
            return "";
        }
        return this.addRunArgs;
    }

    public AppLauncher[] getLaunchers() {
        if (this.launchers == null) {
            return new AppLauncher[0];
        }
        return this.launchers;
    }
}

