/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.WriterAppender;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileAppender
extends WriterAppender {
    protected boolean append = true;
    protected String fileName = null;
    protected boolean bufferedIO = false;
    protected int bufferSize = 8192;

    public void setFile(String file) {
        String val;
        this.fileName = val = file.trim();
    }

    public boolean getAppend() {
        return this.append;
    }

    public String getFile() {
        return this.fileName;
    }

    public void start() {
        int errors = 0;
        if (this.fileName != null) {
            if (this.bufferedIO) {
                this.immediateFlush = false;
                this.addStatus(new InfoStatus("Setting immediateFlush to false on account of bufferedIO option", this));
            }
            try {
                this.setFile();
            }
            catch (IOException e) {
                ++errors;
                this.addStatus(new ErrorStatus("setFile(" + this.fileName + "," + this.append + ") call failed.", this, e));
            }
        } else {
            ++errors;
            this.addStatus(new ErrorStatus("File option not set for appender [" + this.name + "].", this));
        }
        if (errors == 0) {
            super.start();
        }
    }

    public synchronized void setFile() throws IOException {
        this.closeWriter();
        this.writer = this.createWriter(new FileOutputStream(this.fileName, this.append));
        if (this.bufferedIO) {
            this.writer = new BufferedWriter(this.writer, this.bufferSize);
        }
        this.writeHeader();
    }

    public boolean isBufferedIO() {
        return this.bufferedIO;
    }

    public void setBufferedIO(boolean bufferedIO) {
        this.bufferedIO = bufferedIO;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }
}

