/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ExecutionContext;
import ch.qos.logback.core.pattern.util.EscapeUtil;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.xml.sax.Attributes;

public abstract class PropertyAction
extends Action {
    static String INVALID_ATTRIBUTES = "In <property> element, either the \"file\" attribute or both the \"name\" and \"value\" attributes must be set.";

    abstract void setProperties(ExecutionContext var1, Properties var2);

    abstract void setProperty(ExecutionContext var1, String var2, String var3);

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        String name = attributes.getValue("name");
        String value = attributes.getValue("name");
        String fileName = attributes.getValue("file");
        if (!OptionHelper.isEmpty(fileName) && OptionHelper.isEmpty(name) && OptionHelper.isEmpty(value)) {
            Properties props = new Properties();
            try {
                FileInputStream istream = new FileInputStream(fileName);
                props.load(istream);
                istream.close();
                this.setProperties(ec, props);
            }
            catch (IOException e) {
                String errMsg = "Could not read properties file [" + fileName + "].";
                this.addError(errMsg, e);
                this.addError("Ignoring configuration file [" + fileName + "].");
            }
        } else if (!OptionHelper.isEmpty(name) && !OptionHelper.isEmpty(value) && OptionHelper.isEmpty(fileName)) {
            value = EscapeUtil.basicEscape(value);
            value = value.trim();
            this.setProperty(ec, name, value);
        } else {
            this.addError(INVALID_ATTRIBUTES);
        }
    }

    public void end(ExecutionContext ec, String name) {
    }

    public void finish(ExecutionContext ec) {
    }
}

