/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ImplicitAction;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.ExecutionContext;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.joran.spi.RuleStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Interpreter
extends DefaultHandler {
    private static List EMPTY_LIST = new Vector(0);
    private RuleStore ruleStore;
    private ExecutionContext ec;
    private ArrayList<ImplicitAction> implicitActions;
    Pattern pattern;
    Locator locator;
    Stack<List> actionListStack;
    Pattern skip = null;

    public Interpreter(RuleStore rs) {
        this.ruleStore = rs;
        this.ec = new ExecutionContext(this);
        this.implicitActions = new ArrayList(3);
        this.pattern = new Pattern();
        this.actionListStack = new Stack();
    }

    public ExecutionContext getExecutionContext() {
        return this.ec;
    }

    public void startDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        String tagName = this.getTagName(localName, qName);
        System.out.println("startElement [" + tagName + "]");
        this.pattern.push(tagName);
        List applicableActionList = this.getApplicableActionList(this.pattern, atts);
        if (applicableActionList != null) {
            this.actionListStack.add(applicableActionList);
            this.callBeginAction(applicableActionList, tagName, atts);
        } else {
            this.actionListStack.add(EMPTY_LIST);
            String errMsg = "no applicable action for <" + tagName + ">, current pattern is [" + this.pattern + "]";
            this.ec.addError(errMsg);
        }
    }

    public void characters(char[] ch, int start, int length) {
        List applicableActionList = this.actionListStack.peek();
        String body = new String(ch, start, length);
        if (body != null) {
            body = body.trim();
        }
        if (body.length() > 0) {
            System.out.println("calling body method with [" + body + "]");
            this.callBodyAction(applicableActionList, body);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        List applicableActionList = this.actionListStack.pop();
        if (this.skip != null) {
            if (this.skip.equals(this.pattern)) {
                this.skip = null;
            }
        } else if (applicableActionList != EMPTY_LIST) {
            this.callEndAction(applicableActionList, this.getTagName(localName, qName));
        }
        this.pattern.pop();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    String getTagName(String localName, String qName) {
        String tagName = localName;
        if (tagName == null || tagName.length() < 1) {
            tagName = qName;
        }
        return tagName;
    }

    public void addImplicitAction(ImplicitAction ia) {
        this.implicitActions.add(ia);
    }

    List lookupImplicitAction(Pattern pattern, Attributes attributes, ExecutionContext ec) {
        int len = this.implicitActions.size();
        for (int i = 0; i < len; ++i) {
            ImplicitAction ia = this.implicitActions.get(i);
            if (!ia.isApplicable(pattern, attributes, ec)) continue;
            ArrayList<ImplicitAction> actionList = new ArrayList<ImplicitAction>(1);
            actionList.add(ia);
            return actionList;
        }
        return null;
    }

    List getApplicableActionList(Pattern pattern, Attributes attributes) {
        List applicableActionList = this.ruleStore.matchActions(pattern);
        if (applicableActionList == null) {
            applicableActionList = this.lookupImplicitAction(pattern, attributes, this.ec);
        }
        return applicableActionList;
    }

    void callBeginAction(List applicableActionList, String tagName, Attributes atts) {
        if (applicableActionList == null) {
            return;
        }
        if (this.skip != null) {
            return;
        }
        for (Action action : applicableActionList) {
            try {
                action.begin(this.ec, tagName, atts);
            }
            catch (ActionException ae) {
                switch (ae.getSkipCode()) {
                    case 1: {
                        this.skip = (Pattern)this.pattern.clone();
                        break;
                    }
                    case 2: {
                        this.skip = (Pattern)this.pattern.clone();
                        this.skip.pop();
                    }
                }
            }
            catch (Exception e) {
                this.skip = (Pattern)this.pattern.clone();
                this.ec.addError("Exception in Action for tag <" + tagName + ">", this, e);
            }
        }
    }

    void callBodyAction(List applicableActionList, String body) {
        if (applicableActionList == null) {
            return;
        }
        for (Action action : applicableActionList) {
            try {
                action.body(this.ec, body);
            }
            catch (ActionException ae) {
                this.ec.addError("Exception in end() methd for action [" + action + "]", this, ae);
            }
        }
    }

    void callEndAction(List applicableActionList, String tagName) {
        if (applicableActionList == null) {
            return;
        }
        for (Action action : applicableActionList) {
            try {
                action.end(this.ec, tagName);
            }
            catch (ActionException ae) {
                switch (ae.getSkipCode()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.skip = (Pattern)this.pattern.clone();
                        this.skip.pop();
                    }
                }
            }
            catch (Exception e) {
                this.ec.addError("Exception in Action for tag <" + tagName + ">", this, e);
                this.skip = (Pattern)this.pattern.clone();
                this.skip.pop();
            }
        }
    }

    public RuleStore getRuleStore() {
        return this.ruleStore;
    }

    public void setRuleStore(RuleStore ruleStore) {
        this.ruleStore = ruleStore;
    }

    public void error(SAXParseException spe) throws SAXException {
        this.ec.addError("Parsing error", this, spe);
        this.ec.addError("Parsing problem on line " + spe.getLineNumber() + " and column " + spe.getColumnNumber(), this, spe);
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        this.ec.addError("Parsing fatal error", this, spe);
        this.ec.addError("Parsing problem on line " + spe.getLineNumber() + " and column " + spe.getColumnNumber(), this, spe);
    }

    public void warning(SAXParseException spe) throws SAXException {
        this.ec.addWarn("Parsing warning", this, spe);
        this.ec.addWarn("Parsing problem on line " + spe.getLineNumber() + " and column " + spe.getColumnNumber(), this, spe);
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void skippedEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }
}

