/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.parser.ScanException;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FileNamePattern
extends ContextAwareBase {
    static final Map<String, String> CONVERTER_MAP = new HashMap<String, String>();
    String pattern;
    Converter headTokenConverter;

    public FileNamePattern(String patternArg, Context contextArg) {
        this.setPattern(patternArg);
        this.setContext(contextArg);
        this.parse();
        DynamicConverter.startConverters(this.headTokenConverter);
    }

    void parse() {
        try {
            Parser p = new Parser(this.pattern);
            p.setStatusManager(this.getStatusManager());
            Node t = p.parse();
            this.headTokenConverter = p.compile(t, CONVERTER_MAP);
        }
        catch (ScanException sce) {
            this.addError("Failed to parse pattern \"" + this.pattern + "\".", sce);
        }
    }

    public String toString() {
        return this.pattern;
    }

    public DateTokenConverter getDateTokenConverter() {
        for (Converter p = this.headTokenConverter; p != null; p = p.getNext()) {
            if (!(p instanceof DateTokenConverter)) continue;
            return (DateTokenConverter)p;
        }
        return null;
    }

    public IntegerTokenConverter getIntegerTokenConverter() {
        for (Converter p = this.headTokenConverter; p != null; p = p.getNext()) {
            if (!(p instanceof IntegerTokenConverter)) continue;
            return (IntegerTokenConverter)p;
        }
        return null;
    }

    public String convert(Object o) {
        StringBuffer buf = new StringBuffer();
        for (Converter p = this.headTokenConverter; p != null; p = p.getNext()) {
            buf.append(p.convert(o));
        }
        return buf.toString();
    }

    public String convertInt(int i) {
        Integer integerArg = new Integer(i);
        return this.convert(integerArg);
    }

    public String convertDate(Date date) {
        return this.convert(date);
    }

    public void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern.trim();
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    static {
        CONVERTER_MAP.put("i", IntegerTokenConverter.class.getName());
        CONVERTER_MAP.put("d", DateTokenConverter.class.getName());
    }
}

