/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AppenderAttachableImpl
implements AppenderAttachable {
    private final List<Appender> appenderList = new ArrayList<Appender>();

    public void addAppender(Appender newAppender) {
        if (newAppender == null) {
            throw new IllegalArgumentException("Cannot null as an appener");
        }
        if (!this.appenderList.contains(newAppender)) {
            this.appenderList.add(newAppender);
        }
    }

    public int appendLoopOnAppenders(Object o) {
        int size = 0;
        size = this.appenderList.size();
        for (int i = 0; i < size; ++i) {
            Appender appender = this.appenderList.get(i);
            appender.doAppend(o);
        }
        return size;
    }

    public Iterator iteratorForAppenders() {
        return this.appenderList.iterator();
    }

    public Appender getAppender(String name) {
        if (name == null) {
            return null;
        }
        int size = this.appenderList.size();
        for (int i = 0; i < size; ++i) {
            Appender appender = this.appenderList.get(i);
            if (!name.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    public boolean isAttached(Appender appender) {
        if (appender == null) {
            return false;
        }
        int size = this.appenderList.size();
        for (int i = 0; i < size; ++i) {
            Appender a = this.appenderList.get(i);
            if (a != appender) continue;
            return true;
        }
        return false;
    }

    public void detachAndStopAllAppenders() {
        int len = this.appenderList.size();
        for (int i = 0; i < len; ++i) {
            Appender a = this.appenderList.get(i);
            a.stop();
        }
        this.appenderList.clear();
    }

    public boolean detachAppender(Appender appender) {
        if (appender == null) {
            return false;
        }
        return this.appenderList.remove(appender);
    }

    public Appender detachAppender(String name) {
        if (name == null) {
            return null;
        }
        int size = this.appenderList.size();
        for (int i = 0; i < size; ++i) {
            if (!name.equals(this.appenderList.get(i).getName())) continue;
            return this.appenderList.remove(i);
        }
        return null;
    }
}

