/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterAttachable;

public final class FilterAttachableImpl
implements FilterAttachable {
    Filter headFilter;
    Filter tailFilter;

    public void addFilter(Filter newFilter) {
        if (this.headFilter == null) {
            this.headFilter = newFilter;
            this.tailFilter = newFilter;
        } else {
            this.tailFilter.setNext(newFilter);
            this.tailFilter = newFilter;
        }
    }

    public Filter getFirstFilter() {
        return this.headFilter;
    }

    public void clearAllFilters() {
        Filter f = this.headFilter;
        while (f != null) {
            Filter next = f.getNext();
            f.setNext(null);
            f = next;
        }
        f = null;
        this.headFilter = null;
        this.tailFilter = null;
    }

    public int getFilterChainDecision(Object event) {
        Filter f = this.headFilter;
        while (f != null) {
            switch (f.decide(event)) {
                case -1: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 0: {
                    f = f.getNext();
                }
            }
        }
        return 0;
    }
}

