/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class StatusBase
implements Status {
    int level;
    final String message;
    final Object origin;
    List<Status> childrenList;
    Throwable throwable;

    StatusBase(int level, String msg, Object origin) {
        this(level, msg, origin, null);
    }

    StatusBase(int level, String msg, Object origin, Throwable t) {
        this.level = level;
        this.message = msg;
        this.origin = origin;
        this.throwable = t;
    }

    public synchronized void add(Status child) {
        if (child == null) {
            throw new NullPointerException("Null values are not valid Status.");
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Status>();
        }
        this.childrenList.add(child);
    }

    public synchronized boolean hasChildren() {
        return this.childrenList != null && this.childrenList.size() > 0;
    }

    public synchronized Iterator iterator() {
        if (this.childrenList != null) {
            return this.childrenList.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public synchronized boolean remove(Status statusToRemove) {
        if (this.childrenList == null) {
            return false;
        }
        return this.childrenList.remove(statusToRemove);
    }

    public int getLevel() {
        return this.level;
    }

    public int getEffectiveLevel() {
        int result = this.level;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Status s = (Status)it.next();
            int effLevel = s.getEffectiveLevel();
            if (effLevel <= result) continue;
            result = effLevel;
        }
        return result;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getOrigin() {
        return this.origin;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        switch (this.level) {
            case 0: {
                buf.append("INFO");
                break;
            }
            case 1: {
                buf.append("WARN");
                break;
            }
            case 2: {
                buf.append("ERROR");
            }
        }
        if (this.origin != null) {
            buf.append(" in ");
            buf.append(this.origin);
            buf.append(" -");
        }
        buf.append(" ");
        buf.append(this.message);
        if (this.throwable != null) {
            buf.append(" ");
            buf.append(this.throwable);
        }
        return buf.toString();
    }
}

