/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.OptionHelper;
import java.net.URL;

public class Loader {
    static final String TSTR = "Caught Exception while in Loader.getResource. This may be innocuous.";
    private static boolean ignoreTCL = false;

    public static URL getResource(String resource) {
        ClassLoader classLoader = null;
        URL url = null;
        try {
            classLoader = Loader.getTCL();
            if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
                return url;
            }
            classLoader = Loader.class.getClassLoader();
            if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
                return url;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ClassLoader.getSystemResource(resource);
    }

    private static ClassLoader getTCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class loadClass(String clazz) throws ClassNotFoundException {
        if (ignoreTCL) {
            return Class.forName(clazz);
        }
        try {
            return Loader.getTCL().loadClass(clazz);
        }
        catch (Throwable e) {
            return Class.forName(clazz);
        }
    }

    static {
        String ignoreTCLProp = OptionHelper.getSystemProperty("log4j.ignoreTCL", null);
        if (ignoreTCLProp != null) {
            ignoreTCL = OptionHelper.toBoolean(ignoreTCLProp, true);
        }
    }
}

