/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.PropertySetterException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;

public class PropertySetter
extends ContextAwareBase {
    public static final int NOT_FOUND = 0;
    public static final int AS_COMPONENT = 1;
    public static final int AS_PROPERTY = 2;
    public static final int AS_COLLECTION = 3;
    protected Object obj;
    protected Class objClass;
    protected PropertyDescriptor[] propertyDescriptors;
    protected MethodDescriptor[] methodDescriptors;

    public PropertySetter(Object obj) {
        this.obj = obj;
        this.objClass = obj.getClass();
    }

    protected void introspect() {
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.obj.getClass());
            this.propertyDescriptors = bi.getPropertyDescriptors();
            this.methodDescriptors = bi.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            this.addError("Failed to introspect " + this.obj + ": " + ex.getMessage());
            this.propertyDescriptors = new PropertyDescriptor[0];
            this.methodDescriptors = new MethodDescriptor[0];
        }
    }

    public void setProperties(Properties properties, String prefix) {
        int len = prefix.length();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix) || key.indexOf(46, len + 1) > 0) continue;
            String value = OptionHelper.findAndSubst(key, properties);
            if ("layout".equals(key = key.substring(len)) && this.obj instanceof Appender) continue;
            this.setProperty(key, value);
        }
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            return;
        }
        PropertyDescriptor prop = this.getPropertyDescriptor(name = Introspector.decapitalize(name));
        if (prop == null) {
            this.addWarn("No such property [" + name + "] in " + this.objClass.getName() + ".");
        } else {
            try {
                this.setProperty(prop, name, value);
            }
            catch (PropertySetterException ex) {
                this.addWarn("Failed to set property [" + name + "] to value \"" + value + "\". ", ex);
            }
        }
    }

    public void setProperty(PropertyDescriptor prop, String name, String value) throws PropertySetterException {
        Object arg;
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            throw new PropertySetterException("No setter for property [" + name + "].");
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        if (paramTypes.length != 1) {
            throw new PropertySetterException("#params for setter != 1");
        }
        try {
            arg = this.convertArg(value, paramTypes[0]);
        }
        catch (Throwable t) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed. ", t);
        }
        if (arg == null) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed.");
        }
        try {
            setter.invoke(this.obj, arg);
        }
        catch (Exception ex) {
            throw new PropertySetterException(ex);
        }
    }

    public int canContainComponent(String name) {
        Method setterMethod;
        String cName = this.capitalizeFirstLetter(name);
        Method method = this.getMethod("add" + cName);
        if (method != null) {
            return 3;
        }
        String dName = Introspector.decapitalize(name);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(dName);
        if (propertyDescriptor != null && (setterMethod = propertyDescriptor.getWriteMethod()) != null) {
            Class<?>[] classArray = setterMethod.getParameterTypes();
            if (classArray.length != 1) {
                return 0;
            }
            Class<?> clazz = classArray[0];
            Package p = clazz.getPackage();
            if (clazz.isPrimitive()) {
                return 2;
            }
            if ("java.lang".equals(p.getName())) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public Class getObjClass() {
        return this.objClass;
    }

    public void addComponent(String name, Object childComponent) {
        Class<?> ccc = childComponent.getClass();
        name = this.capitalizeFirstLetter(name);
        Method method = this.getMethod("add" + name);
        if (method != null) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length == 1) {
                if (params[0].isAssignableFrom(childComponent.getClass())) {
                    try {
                        method.invoke(this.obj, childComponent);
                    }
                    catch (Exception e) {
                        this.addError("Could not invoke method " + method.getName() + " in class " + this.obj.getClass().getName() + " with parameter of type " + ccc.getName(), e);
                    }
                } else {
                    this.addError("A \"" + ccc.getName() + "\" object is not assignable to a \"" + params[0].getName() + "\" variable.");
                    this.addError("The class \"" + params[0].getName() + "\" was loaded by ");
                    this.addError("[" + params[0].getClassLoader() + "] whereas object of type ");
                    this.addError("\"" + ccc.getName() + "\" was loaded by [" + ccc.getClassLoader() + "].");
                }
            }
        } else {
            this.addError("Could not find method [add" + name + "] in class [" + this.objClass.getName() + "].");
        }
    }

    public void setComponent(String name, Object childComponent) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(name);
        if (propertyDescriptor == null) {
            this.addWarn("Could not find PropertyDescriptor for [" + name + "] in " + this.objClass.getName());
            return;
        }
        Method setter = propertyDescriptor.getWriteMethod();
        if (setter == null) {
            this.addWarn("Not setter method for property [" + name + "] in " + this.obj.getClass().getName());
            return;
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        if (paramTypes.length != 1) {
            this.addError("Wrong number of parameters in setter method for property [" + name + "] in " + this.obj.getClass().getName());
            return;
        }
        try {
            setter.invoke(this.obj, childComponent);
        }
        catch (Exception e) {
            this.addError("Could not set component " + this.obj + " for parent component " + this.obj, e);
        }
    }

    String capitalizeFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected Object convertArg(String val, Class type) {
        if (val == null) {
            return null;
        }
        String v = val.trim();
        if (String.class.isAssignableFrom(type)) {
            return val;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return new Integer(v);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return new Long(v);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            if ("true".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected Method getMethod(String methodName) {
        if (this.methodDescriptors == null) {
            this.introspect();
        }
        for (int i = 0; i < this.methodDescriptors.length; ++i) {
            if (!methodName.equals(this.methodDescriptors[i].getName())) continue;
            return this.methodDescriptors[i].getMethod();
        }
        return null;
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        if (this.propertyDescriptors == null) {
            this.introspect();
        }
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            if (!name.equals(this.propertyDescriptors[i].getName())) continue;
            return this.propertyDescriptors[i];
        }
        return null;
    }
}

