/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.SaxEventInterpreter;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Stack;

public class IncludeModelHandler
extends ModelHandlerBase {
    private boolean optional;
    private String attributeInUse;

    public IncludeModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, InterpretationContext ic) {
        return new IncludeModelHandler(context);
    }

    protected Class<IncludeModel> getSupportedModelClass() {
        return IncludeModel.class;
    }

    @Override
    public void handle(InterpretationContext intercon, Model model) throws ModelHandlerException {
        IncludeModel includeModel = (IncludeModel)model;
        SaxEventRecorder localRecorder = new SaxEventRecorder(this.context, includeModel.getElementPath()){

            @Override
            public boolean shouldIgnoreForElementPath(String tagName) {
                return "included".equalsIgnoreCase(tagName);
            }
        };
        this.optional = OptionHelper.toBoolean(includeModel.getOptional(), false);
        if (!this.checkAttributes(includeModel)) {
            return;
        }
        InputStream in = this.getInputStream(intercon, includeModel);
        try {
            try {
                if (in != null) {
                    this.parseAndRecord(in, localRecorder);
                    this.trimHeadAndTail(localRecorder, "included");
                    SaxEventInterpreter localInterpreter = intercon.getSaxEventInterpreter().duplicate(includeModel.getElementPath());
                    localInterpreter.getEventPlayer().play(localRecorder.saxEventList);
                    this.transferModelStack(includeModel, localInterpreter);
                }
            }
            catch (JoranException e) {
                this.addError("Error while parsing  " + this.attributeInUse, e);
                this.close(in);
            }
        }
        finally {
            this.close(in);
        }
    }

    private void transferModelStack(IncludeModel includeModel, SaxEventInterpreter subInterpreter) {
        Stack<Model> copy = subInterpreter.getInterpretationContext().getCopyOfModelStack();
        for (Model m : copy) {
            includeModel.addSubModel(m);
        }
    }

    private void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkAttributes(IncludeModel includeModel) {
        int count = 0;
        if (!OptionHelper.isNullOrEmpty(includeModel.getFile())) {
            ++count;
        }
        if (!OptionHelper.isNullOrEmpty(includeModel.getUrl())) {
            ++count;
        }
        if (!OptionHelper.isNullOrEmpty(includeModel.getResource())) {
            ++count;
        }
        if (count == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (count > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (count == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + count + "] is not expected");
    }

    private InputStream getInputStream(InterpretationContext ec, IncludeModel includeModel) {
        URL inputURL = this.getInputURL(ec, includeModel);
        if (inputURL == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, inputURL);
        return this.openURL(inputURL);
    }

    private URL getInputURL(InterpretationContext ec, IncludeModel includeModel) {
        String fileAttribute = includeModel.getFile();
        String urlAttribute = includeModel.getUrl();
        String resourceAttribute = includeModel.getResource();
        if (!OptionHelper.isNullOrEmpty(fileAttribute)) {
            this.attributeInUse = ec.subst(fileAttribute);
            return this.filePathAsURL(this.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmpty(urlAttribute)) {
            this.attributeInUse = ec.subst(urlAttribute);
            return this.attributeToURL(this.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmpty(resourceAttribute)) {
            this.attributeInUse = ec.subst(resourceAttribute);
            return this.resourceAsURL(this.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned");
    }

    private InputStream openURL(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            this.optionalWarning("Failed to open [" + url.toString() + "]");
            return null;
        }
    }

    private URL attributeToURL(String urlAttribute) {
        try {
            return new URL(urlAttribute);
        }
        catch (MalformedURLException mue) {
            String errMsg = "URL [" + urlAttribute + "] is not well formed.";
            this.addError(errMsg, mue);
            return null;
        }
    }

    private URL resourceAsURL(String resourceAttribute) {
        URL url = Loader.getResourceBySelfClassLoader(resourceAttribute);
        if (url == null) {
            this.optionalWarning("Could not find resource corresponding to [" + resourceAttribute + "]");
            return null;
        }
        return url;
    }

    private void optionalWarning(String msg) {
        if (!this.optional) {
            this.addWarn(msg);
        }
    }

    URL filePathAsURL(String path) {
        URI uri = new File(path).toURI();
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void parseAndRecord(InputStream inputSource, SaxEventRecorder recorder) throws JoranException {
        recorder.setContext(this.context);
        recorder.recordEvents(inputSource);
    }

    private void trimHeadAndTail(SaxEventRecorder recorder, String tagName) {
        SaxEvent last;
        List<SaxEvent> saxEventList = recorder.saxEventList;
        if (saxEventList.size() == 0) {
            return;
        }
        SaxEvent first = saxEventList.get(0);
        if (first != null && first.qName.equalsIgnoreCase(tagName)) {
            saxEventList.remove(0);
        }
        if ((last = saxEventList.get(recorder.saxEventList.size() - 1)) != null && last.qName.equalsIgnoreCase(tagName)) {
            saxEventList.remove(recorder.saxEventList.size() - 1);
        }
    }
}

