/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.concurrent;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestFactory {
    private final String algorithm;
    private final MessageDigest digestPrototype;
    private final boolean supportsClone;

    public MessageDigestFactory(String algorithm) {
        this.algorithm = algorithm;
        this.digestPrototype = MessageDigestFactory.createJDKDigest(algorithm);
        this.supportsClone = MessageDigestFactory.supportsCloning(this.digestPrototype);
    }

    public MessageDigest newDigest() {
        if (this.supportsClone) {
            try {
                return (MessageDigest)this.digestPrototype.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return MessageDigestFactory.createJDKDigest(this.algorithm);
    }

    private static boolean supportsCloning(MessageDigest messageDigest) {
        try {
            messageDigest.clone();
            return true;
        }
        catch (CloneNotSupportedException e) {
            return false;
        }
    }

    private static MessageDigest createJDKDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

