/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.profiler;

import cloud.orbit.io.StringBuilderWriter;
import cloud.orbit.profiler.CallTreeElement;
import cloud.orbit.profiler.MethodInfo;
import cloud.orbit.profiler.ProfilerData;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class ProfileDump {
    private ProfileDump() {
    }

    public static String textMethodInfo(ProfilerData data, long globalCount) {
        StringBuilderWriter sw = new StringBuilderWriter();
        PrintWriter pw = new PrintWriter(sw);
        float limit = 5.0f;
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>(data.getMethods());
        long sampleCount = data.getSampleCount();
        Collections.sort(methods, (a, b) -> -Long.compare(a.count, b.count));
        for (MethodInfo m : methods) {
            if (sampleCount != 0L && (double)limit > (double)m.count * 100.0 / (double)sampleCount) break;
            if (globalCount != 0L) {
                pw.print(String.format("%.2f", (double)m.count * 100.0 / (double)globalCount));
                pw.print("\t");
            }
            if (sampleCount != 0L) {
                pw.print(String.format("%.2f", (double)m.count * 100.0 / (double)sampleCount));
                pw.print("\t");
            }
            pw.print(m.count);
            pw.print("\t");
            pw.print(m.declaringClass);
            pw.print(".");
            pw.print(m.methodName);
            pw.println();
        }
        return sw.toString();
    }

    public static String textDumpCallTree(CallTreeElement root, long globalCount) {
        StringBuilderWriter sw = new StringBuilderWriter();
        PrintWriter pw = new PrintWriter(sw);
        ProfileDump.textDumpCallTree(64, pw, "", root, root.count, globalCount);
        return sw.toString();
    }

    public static void textDumpCallTree(int depthLimit, PrintWriter pw, String prefix, CallTreeElement start, long sampleCount, long globalCount) {
        float limit = 5.0f;
        ArrayList<CallTreeElement> methods = new ArrayList<CallTreeElement>(start.children.values());
        Collections.sort(methods, (c1, c2) -> -Long.compare(c1.count, c2.count));
        for (int i = 0; i < methods.size(); ++i) {
            boolean hasMore;
            CallTreeElement m = methods.get(i);
            float percTotalGlobal = (float)m.count * 100.0f / (float)globalCount;
            float percTotal = (float)m.count * 100.0f / (float)sampleCount;
            if (!(percTotal > limit)) continue;
            float percMethod = (float)m.elementInfo.count * 100.0f / (float)sampleCount;
            pw.print(String.format("%6.2f%%", Float.valueOf(percTotalGlobal)));
            pw.print("\t");
            pw.print(String.format("%6.2f%%", Float.valueOf(percTotal)));
            pw.print("\t");
            pw.print(String.format("%6.2f%%", Float.valueOf(percMethod)));
            pw.print("\t");
            pw.print(prefix);
            pw.print("+- ");
            pw.print(m.elementInfo.methodName);
            pw.print("\t");
            pw.print(m.elementInfo.declaringClass);
            pw.println();
            boolean bl = hasMore = i + 1 < methods.size();
            if (hasMore) {
                CallTreeElement m2 = methods.get(i + 1);
                float percTotal2 = (float)m2.count * 100.0f / (float)sampleCount;
                boolean bl2 = hasMore = percTotal2 > limit;
            }
            if (depthLimit <= 0) continue;
            ProfileDump.textDumpCallTree(--depthLimit, pw, hasMore ? prefix + "|  " : prefix + "   ", m, sampleCount, globalCount);
        }
    }
}

