/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static Date parseExact(String value, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault());
        return formatter.parse(value);
    }

    public static String getStringFromDate(Date date, String dateFormatString) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatString, Locale.getDefault());
        return sdf.format(date);
    }

    public static Date getDateFromString(String dateString, String dateFormatString) {
        try {
            return DateTimeUtils.parseExact(dateString, dateFormatString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Date could not be parsed in the specified format: " + dateFormatString + " - " + e.getMessage());
        }
    }

    public static boolean isDateInRange(Date dateToCheck, Date startDate, Date endDate) {
        return !(startDate != null && dateToCheck.before(startDate) || endDate != null && dateToCheck.after(endDate));
    }

    public static Date getDateRelativeToNow(TimeUnit timeUnit, long amount) {
        return new Date(System.currentTimeMillis() + timeUnit.toMillis(amount));
    }
}

