/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class IOUtils {
    private IOUtils() {
    }

    public static String toString(InputStream input) throws IOException {
        return IOUtils.toString(input, Charset.defaultCharset());
    }

    public static String toString(InputStream input, Charset encoding) throws IOException {
        return IOUtils.toString(new InputStreamReader(input, encoding));
    }

    public static String toString(Reader input) throws IOException {
        int charsRead;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[4096];
        while (-1 != (charsRead = input.read(buffer))) {
            sb.append(buffer, 0, charsRead);
        }
        return sb.toString();
    }

    public static void copy(Reader input, Writer output) throws IOException {
        int charsRead;
        char[] buffer = new char[4096];
        while (-1 != (charsRead = input.read(buffer))) {
            output.write(buffer, 0, charsRead);
        }
    }

    public static void copy(Reader input, File output) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charset.defaultCharset());){
            IOUtils.copy(input, writer);
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[Math.max(1024, input.available())];
        int offset = 0;
        while (-1 != (bytesRead = input.read(buffer, offset, buffer.length - offset))) {
            if ((offset += bytesRead) != buffer.length) continue;
            buffer = Arrays.copyOf(buffer, buffer.length + Math.max(input.available(), buffer.length >> 1));
        }
        return offset == buffer.length ? buffer : Arrays.copyOf(buffer, offset);
    }

    public static void silentlyClose(Closeable toClose) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

