/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.util;

import cloud.orbit.exception.UncheckedException;
import java.io.IOException;
import java.net.ServerSocket;

public class NetUtils {
    private NetUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findFreePort() {
        try (ServerSocket socket1 = new ServerSocket(0);){
            int n = socket1.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new UncheckedException("Error trying to find a free port", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findFreePort(int start) {
        if (start == 0) {
            return NetUtils.findFreePort();
        }
        int i = start;
        while (i < 65535) {
            try (ServerSocket socket1 = new ServerSocket();){
                int n = socket1.getLocalPort();
                return n;
            }
            catch (IOException iOException) {
                i = (int)((double)i + Math.random() * 50.0);
            }
        }
        throw new UncheckedException("No free ports found");
    }
}

