/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.enable;

import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.config.BootstrapPropertiesInterface;
import cn.hippo4j.core.config.ConfigEmptyException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
public class BeforeCheckConfiguration {
    private final String bootstrapPropertiesClassName = "cn.hippo4j.starter.config.BootstrapProperties";

    @Bean
    public BeforeCheck dynamicThreadPoolBeforeCheckBean(@Autowired(required=false) BootstrapPropertiesInterface properties, ConfigurableEnvironment environment) {
        boolean checkFlag;
        boolean bl = checkFlag = properties != null && Objects.equals("cn.hippo4j.starter.config.BootstrapProperties", properties.getClass().getName()) && properties.getEnable() != false;
        if (checkFlag) {
            String username = properties.getUsername();
            if (StringUtil.isBlank((CharSequence)username)) {
                throw new ConfigEmptyException("Web server failed to start. The dynamic thread pool username is empty.", "Please check whether the [spring.dynamic.thread-pool.username] configuration is empty or an empty string.");
            }
            String password = properties.getPassword();
            if (StringUtil.isBlank((CharSequence)password)) {
                throw new ConfigEmptyException("Web server failed to start. The dynamic thread pool password is empty.", "Please check whether the [spring.dynamic.thread-pool.password] configuration is empty or an empty string.");
            }
            String namespace = properties.getNamespace();
            if (StringUtil.isBlank((CharSequence)namespace)) {
                throw new ConfigEmptyException("Web server failed to start. The dynamic thread pool namespace is empty.", "Please check whether the [spring.dynamic.thread-pool.namespace] configuration is empty or an empty string.");
            }
            String itemId = properties.getItemId();
            if (StringUtil.isBlank((CharSequence)itemId)) {
                throw new ConfigEmptyException("Web server failed to start. The dynamic thread pool item id is empty.", "Please check whether the [spring.dynamic.thread-pool.item-id] configuration is empty or an empty string.");
            }
            String serverAddr = properties.getServerAddr();
            if (StringUtil.isBlank((CharSequence)serverAddr)) {
                throw new ConfigEmptyException("Web server failed to start. The dynamic thread pool server addr is empty.", "Please check whether the [spring.dynamic.thread-pool.server-addr] configuration is empty or an empty string.");
            }
            String applicationName = environment.getProperty("spring.application.name");
            if (StringUtil.isBlank((CharSequence)applicationName)) {
                throw new ConfigEmptyException("Web server failed to start. The dynamic thread pool application name is empty.", "Please check whether the [spring.application.name] configuration is empty or an empty string.");
            }
        }
        return new BeforeCheck();
    }

    public class BeforeCheck {
    }
}

