/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor;

import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.proxy.RejectedProxyUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.springframework.core.task.TaskDecorator;

public class DynamicThreadPoolExecutor
extends AbstractDynamicExecutorSupport {
    private TaskDecorator taskDecorator;
    private RejectedExecutionHandler redundancyHandler;
    private final String threadPoolId;
    private final AtomicLong rejectCount = new AtomicLong();

    public DynamicThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, boolean waitForTasksToCompleteOnShutdown, long awaitTerminationMillis, @NonNull BlockingQueue<Runnable> workQueue, @NonNull String threadPoolId, @NonNull ThreadFactory threadFactory, @NonNull RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, waitForTasksToCompleteOnShutdown, awaitTerminationMillis, workQueue, threadPoolId, threadFactory, handler);
        if (workQueue == null) {
            throw new NullPointerException("workQueue is marked non-null but is null");
        }
        if (threadPoolId == null) {
            throw new NullPointerException("threadPoolId is marked non-null but is null");
        }
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.threadPoolId = threadPoolId;
        RejectedExecutionHandler rejectedProxy = RejectedProxyUtil.createProxy(handler, threadPoolId, this.rejectCount);
        this.setRejectedExecutionHandler(rejectedProxy);
        this.redundancyHandler = handler;
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (this.taskDecorator != null) {
            command = this.taskDecorator.decorate(command);
        }
        super.execute(command);
    }

    @Override
    protected ExecutorService initializeExecutor() {
        return this;
    }

    public Long getRejectCountNum() {
        return this.rejectCount.get();
    }

    public TaskDecorator getTaskDecorator() {
        return this.taskDecorator;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    public RejectedExecutionHandler getRedundancyHandler() {
        return this.redundancyHandler;
    }

    public void setRedundancyHandler(RejectedExecutionHandler redundancyHandler) {
        this.redundancyHandler = redundancyHandler;
    }

    public String getThreadPoolId() {
        return this.threadPoolId;
    }

    public AtomicLong getRejectCount() {
        return this.rejectCount;
    }
}

