/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.spi;

import cn.hippo4j.core.spi.ServiceLoaderInstantiationException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DynamicThreadPoolServiceLoader {
    private static final Map<Class<?>, Collection<Object>> SERVICES = new ConcurrentHashMap();

    public static void register(Class<?> serviceInterface) {
        if (!SERVICES.containsKey(serviceInterface)) {
            SERVICES.put(serviceInterface, DynamicThreadPoolServiceLoader.load(serviceInterface));
        }
    }

    private static <T> Collection<Object> load(Class<T> serviceInterface) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (T each : ServiceLoader.load(serviceInterface)) {
            result.add(each);
        }
        return result;
    }

    public static <T> Collection<T> getSingletonServiceInstances(Class<T> service) {
        return SERVICES.getOrDefault(service, Collections.emptyList());
    }

    public static <T> Collection<T> newServiceInstances(Class<T> service) {
        return SERVICES.containsKey(service) ? (Collection)SERVICES.get(service).stream().map(each -> DynamicThreadPoolServiceLoader.newServiceInstance(each.getClass())).collect(Collectors.toList()) : Collections.emptyList();
    }

    private static Object newServiceInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ServiceLoaderInstantiationException(clazz, ex);
        }
    }
}

