/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor;

import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.executor.support.CommonDynamicThreadPool;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.DisposableBean;

public class DynamicThreadPoolWrapper
implements DisposableBean {
    private String tenantId;
    private String itemId;
    private String threadPoolId;
    private boolean subscribeFlag;
    private boolean initFlag;
    private ThreadPoolExecutor executor;

    public DynamicThreadPoolWrapper(String threadPoolId) {
        this(threadPoolId, CommonDynamicThreadPool.getInstance(threadPoolId));
    }

    public DynamicThreadPoolWrapper(String threadPoolId, ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolId = threadPoolId;
        this.executor = threadPoolExecutor;
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    public void destroy() throws Exception {
        if (this.executor != null && this.executor instanceof AbstractDynamicExecutorSupport) {
            ((AbstractDynamicExecutorSupport)this.executor).destroy();
        }
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getThreadPoolId() {
        return this.threadPoolId;
    }

    public boolean isSubscribeFlag() {
        return this.subscribeFlag;
    }

    public boolean isInitFlag() {
        return this.initFlag;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setThreadPoolId(String threadPoolId) {
        this.threadPoolId = threadPoolId;
    }

    public void setSubscribeFlag(boolean subscribeFlag) {
        this.subscribeFlag = subscribeFlag;
    }

    public void setInitFlag(boolean initFlag) {
        this.initFlag = initFlag;
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicThreadPoolWrapper)) {
            return false;
        }
        DynamicThreadPoolWrapper other = (DynamicThreadPoolWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$itemId = this.getItemId();
        String other$itemId = other.getItemId();
        if (this$itemId == null ? other$itemId != null : !this$itemId.equals(other$itemId)) {
            return false;
        }
        String this$threadPoolId = this.getThreadPoolId();
        String other$threadPoolId = other.getThreadPoolId();
        if (this$threadPoolId == null ? other$threadPoolId != null : !this$threadPoolId.equals(other$threadPoolId)) {
            return false;
        }
        if (this.isSubscribeFlag() != other.isSubscribeFlag()) {
            return false;
        }
        if (this.isInitFlag() != other.isInitFlag()) {
            return false;
        }
        ThreadPoolExecutor this$executor = this.getExecutor();
        ThreadPoolExecutor other$executor = other.getExecutor();
        return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicThreadPoolWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : $itemId.hashCode());
        String $threadPoolId = this.getThreadPoolId();
        result = result * 59 + ($threadPoolId == null ? 43 : $threadPoolId.hashCode());
        result = result * 59 + (this.isSubscribeFlag() ? 79 : 97);
        result = result * 59 + (this.isInitFlag() ? 79 : 97);
        ThreadPoolExecutor $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        return result;
    }

    public String toString() {
        return "DynamicThreadPoolWrapper(tenantId=" + this.getTenantId() + ", itemId=" + this.getItemId() + ", threadPoolId=" + this.getThreadPoolId() + ", subscribeFlag=" + this.isSubscribeFlag() + ", initFlag=" + this.isInitFlag() + ", executor=" + this.getExecutor() + ")";
    }
}

