/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.state;

import cn.hippo4j.common.model.ManyThreadPoolRunStateInfo;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.common.toolkit.ByteConvertUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.state.AbstractThreadPoolRuntime;
import cn.hippo4j.core.executor.state.ThreadPoolStatusHandler;
import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.toolkit.IdentifyUtil;
import cn.hippo4j.core.toolkit.inet.InetUtils;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.RuntimeInfo;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class ThreadPoolRunStateHandler
extends AbstractThreadPoolRuntime {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolRunStateHandler.class);
    private final InetUtils hippo4JInetUtils;
    private final ConfigurableEnvironment environment;

    @Override
    public ThreadPoolRunStateInfo supplement(ThreadPoolRunStateInfo poolRunStateInfo) {
        RuntimeInfo runtimeInfo = new RuntimeInfo();
        String memoryProportion = StrUtil.builder((CharSequence[])new CharSequence[]{"\u5df2\u5206\u914d: ", ByteConvertUtil.getPrintSize((long)runtimeInfo.getTotalMemory()), " / \u6700\u5927\u53ef\u7528: ", ByteConvertUtil.getPrintSize((long)runtimeInfo.getMaxMemory())}).toString();
        poolRunStateInfo.setCurrentLoad(poolRunStateInfo.getCurrentLoad() + "%");
        poolRunStateInfo.setPeakLoad(poolRunStateInfo.getPeakLoad() + "%");
        String ipAddress = this.hippo4JInetUtils.findFirstNonLoopBackHostInfo().getIpAddress();
        poolRunStateInfo.setHost(ipAddress);
        poolRunStateInfo.setMemoryProportion(memoryProportion);
        poolRunStateInfo.setFreeMemory(ByteConvertUtil.getPrintSize((long)runtimeInfo.getFreeMemory()));
        String threadPoolId = poolRunStateInfo.getTpId();
        DynamicThreadPoolWrapper executorService = GlobalThreadPoolManage.getExecutorService(threadPoolId);
        ThreadPoolExecutor pool = executorService.getExecutor();
        String rejectedName = pool instanceof AbstractDynamicExecutorSupport ? ((DynamicThreadPoolExecutor)pool).getRedundancyHandler().getClass().getSimpleName() : pool.getRejectedExecutionHandler().getClass().getSimpleName();
        poolRunStateInfo.setRejectedName(rejectedName);
        ManyThreadPoolRunStateInfo manyThreadPoolRunStateInfo = (ManyThreadPoolRunStateInfo)BeanUtil.toBean((Object)poolRunStateInfo, ManyThreadPoolRunStateInfo.class);
        manyThreadPoolRunStateInfo.setIdentify(IdentifyUtil.CLIENT_IDENTIFICATION_VALUE);
        String active = this.environment.getProperty("spring.profiles.active", "UNKNOWN");
        manyThreadPoolRunStateInfo.setActive(active.toUpperCase());
        String threadPoolState = ThreadPoolStatusHandler.getThreadPoolState(pool);
        manyThreadPoolRunStateInfo.setState(threadPoolState);
        return manyThreadPoolRunStateInfo;
    }

    public ThreadPoolRunStateHandler(InetUtils hippo4JInetUtils, ConfigurableEnvironment environment) {
        this.hippo4JInetUtils = hippo4JInetUtils;
        this.environment = environment;
    }
}

