/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.support;

import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.support.FastThreadPoolExecutor;
import cn.hippo4j.core.executor.support.TaskQueue;
import cn.hippo4j.core.executor.support.ThreadFactoryBuilder;
import cn.hippo4j.core.executor.support.ThreadPoolExecutorTemplate;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskDecorator;

public class AbstractBuildThreadPoolTemplate {
    private static final Logger log = LoggerFactory.getLogger(AbstractBuildThreadPoolTemplate.class);

    protected static ThreadPoolInitParam initParam() {
        throw new UnsupportedOperationException();
    }

    public static ThreadPoolExecutor buildPool() {
        ThreadPoolInitParam initParam = AbstractBuildThreadPoolTemplate.initParam();
        return AbstractBuildThreadPoolTemplate.buildPool(initParam);
    }

    public static ThreadPoolExecutor buildPool(ThreadPoolInitParam initParam) {
        ThreadPoolExecutorTemplate executorService;
        Assert.notNull((Object)initParam);
        try {
            executorService = new ThreadPoolExecutorTemplate(initParam.getCorePoolNum(), initParam.getMaxPoolNum(), initParam.getKeepAliveTime(), initParam.getTimeUnit(), initParam.getWorkQueue(), initParam.getThreadFactory(), initParam.rejectedExecutionHandler);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Error creating thread pool parameter.", ex);
        }
        executorService.allowCoreThreadTimeOut(initParam.allowCoreThreadTimeOut);
        return executorService;
    }

    public static ThreadPoolExecutor buildFastPool() {
        ThreadPoolInitParam initParam = AbstractBuildThreadPoolTemplate.initParam();
        return AbstractBuildThreadPoolTemplate.buildFastPool(initParam);
    }

    public static ThreadPoolExecutor buildFastPool(ThreadPoolInitParam initParam) {
        FastThreadPoolExecutor fastThreadPoolExecutor;
        TaskQueue<Runnable> taskQueue = new TaskQueue<Runnable>(initParam.getCapacity());
        try {
            fastThreadPoolExecutor = new FastThreadPoolExecutor((int)initParam.getCorePoolNum(), (int)initParam.getMaxPoolNum(), (long)initParam.getKeepAliveTime(), initParam.getTimeUnit(), taskQueue, initParam.getThreadFactory(), initParam.rejectedExecutionHandler);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Error creating thread pool parameter.", ex);
        }
        taskQueue.setExecutor(fastThreadPoolExecutor);
        fastThreadPoolExecutor.allowCoreThreadTimeOut(initParam.allowCoreThreadTimeOut);
        return fastThreadPoolExecutor;
    }

    public static DynamicThreadPoolExecutor buildDynamicPool(ThreadPoolInitParam initParam) {
        DynamicThreadPoolExecutor dynamicThreadPoolExecutor;
        Assert.notNull((Object)initParam);
        try {
            dynamicThreadPoolExecutor = new DynamicThreadPoolExecutor(initParam.getCorePoolNum(), initParam.getMaxPoolNum(), initParam.getKeepAliveTime(), initParam.getTimeUnit(), initParam.getExecuteTimeOut(), initParam.getWaitForTasksToCompleteOnShutdown(), initParam.getAwaitTerminationMillis(), initParam.getWorkQueue(), initParam.getThreadPoolId(), initParam.getThreadFactory(), initParam.getRejectedExecutionHandler());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Error creating thread pool parameter. threadPool id: %s", initParam.getThreadPoolId()), ex);
        }
        dynamicThreadPoolExecutor.setTaskDecorator(initParam.getTaskDecorator());
        dynamicThreadPoolExecutor.allowCoreThreadTimeOut(initParam.allowCoreThreadTimeOut);
        return dynamicThreadPoolExecutor;
    }

    public static class ThreadPoolInitParam {
        private Integer corePoolNum;
        private Integer maxPoolNum;
        private Long keepAliveTime;
        private TimeUnit timeUnit;
        private Long executeTimeOut;
        private Integer capacity;
        private BlockingQueue<Runnable> workQueue;
        private RejectedExecutionHandler rejectedExecutionHandler;
        private ThreadFactory threadFactory;
        private String threadPoolId;
        private TaskDecorator taskDecorator;
        private Long awaitTerminationMillis;
        private Boolean waitForTasksToCompleteOnShutdown;
        private Boolean allowCoreThreadTimeOut = false;

        public ThreadPoolInitParam(String threadNamePrefix, boolean isDaemon) {
            this.threadFactory = ThreadFactoryBuilder.builder().prefix(threadNamePrefix).daemon(isDaemon).build();
        }

        public ThreadPoolInitParam(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public Integer getCorePoolNum() {
            return this.corePoolNum;
        }

        public Integer getMaxPoolNum() {
            return this.maxPoolNum;
        }

        public Long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public Long getExecuteTimeOut() {
            return this.executeTimeOut;
        }

        public Integer getCapacity() {
            return this.capacity;
        }

        public BlockingQueue<Runnable> getWorkQueue() {
            return this.workQueue;
        }

        public RejectedExecutionHandler getRejectedExecutionHandler() {
            return this.rejectedExecutionHandler;
        }

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public String getThreadPoolId() {
            return this.threadPoolId;
        }

        public TaskDecorator getTaskDecorator() {
            return this.taskDecorator;
        }

        public Long getAwaitTerminationMillis() {
            return this.awaitTerminationMillis;
        }

        public Boolean getWaitForTasksToCompleteOnShutdown() {
            return this.waitForTasksToCompleteOnShutdown;
        }

        public Boolean getAllowCoreThreadTimeOut() {
            return this.allowCoreThreadTimeOut;
        }

        public ThreadPoolInitParam setCorePoolNum(Integer corePoolNum) {
            this.corePoolNum = corePoolNum;
            return this;
        }

        public ThreadPoolInitParam setMaxPoolNum(Integer maxPoolNum) {
            this.maxPoolNum = maxPoolNum;
            return this;
        }

        public ThreadPoolInitParam setKeepAliveTime(Long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        public ThreadPoolInitParam setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public ThreadPoolInitParam setExecuteTimeOut(Long executeTimeOut) {
            this.executeTimeOut = executeTimeOut;
            return this;
        }

        public ThreadPoolInitParam setCapacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public ThreadPoolInitParam setWorkQueue(BlockingQueue<Runnable> workQueue) {
            this.workQueue = workQueue;
            return this;
        }

        public ThreadPoolInitParam setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            this.rejectedExecutionHandler = rejectedExecutionHandler;
            return this;
        }

        public ThreadPoolInitParam setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ThreadPoolInitParam setThreadPoolId(String threadPoolId) {
            this.threadPoolId = threadPoolId;
            return this;
        }

        public ThreadPoolInitParam setTaskDecorator(TaskDecorator taskDecorator) {
            this.taskDecorator = taskDecorator;
            return this;
        }

        public ThreadPoolInitParam setAwaitTerminationMillis(Long awaitTerminationMillis) {
            this.awaitTerminationMillis = awaitTerminationMillis;
            return this;
        }

        public ThreadPoolInitParam setWaitForTasksToCompleteOnShutdown(Boolean waitForTasksToCompleteOnShutdown) {
            this.waitForTasksToCompleteOnShutdown = waitForTasksToCompleteOnShutdown;
            return this;
        }

        public ThreadPoolInitParam setAllowCoreThreadTimeOut(Boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadPoolInitParam)) {
                return false;
            }
            ThreadPoolInitParam other = (ThreadPoolInitParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$corePoolNum = this.getCorePoolNum();
            Integer other$corePoolNum = other.getCorePoolNum();
            if (this$corePoolNum == null ? other$corePoolNum != null : !((Object)this$corePoolNum).equals(other$corePoolNum)) {
                return false;
            }
            Integer this$maxPoolNum = this.getMaxPoolNum();
            Integer other$maxPoolNum = other.getMaxPoolNum();
            if (this$maxPoolNum == null ? other$maxPoolNum != null : !((Object)this$maxPoolNum).equals(other$maxPoolNum)) {
                return false;
            }
            Long this$keepAliveTime = this.getKeepAliveTime();
            Long other$keepAliveTime = other.getKeepAliveTime();
            if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
                return false;
            }
            TimeUnit this$timeUnit = this.getTimeUnit();
            TimeUnit other$timeUnit = other.getTimeUnit();
            if (this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit)) {
                return false;
            }
            Long this$executeTimeOut = this.getExecuteTimeOut();
            Long other$executeTimeOut = other.getExecuteTimeOut();
            if (this$executeTimeOut == null ? other$executeTimeOut != null : !((Object)this$executeTimeOut).equals(other$executeTimeOut)) {
                return false;
            }
            Integer this$capacity = this.getCapacity();
            Integer other$capacity = other.getCapacity();
            if (this$capacity == null ? other$capacity != null : !((Object)this$capacity).equals(other$capacity)) {
                return false;
            }
            BlockingQueue<Runnable> this$workQueue = this.getWorkQueue();
            BlockingQueue<Runnable> other$workQueue = other.getWorkQueue();
            if (this$workQueue == null ? other$workQueue != null : !this$workQueue.equals(other$workQueue)) {
                return false;
            }
            RejectedExecutionHandler this$rejectedExecutionHandler = this.getRejectedExecutionHandler();
            RejectedExecutionHandler other$rejectedExecutionHandler = other.getRejectedExecutionHandler();
            if (this$rejectedExecutionHandler == null ? other$rejectedExecutionHandler != null : !this$rejectedExecutionHandler.equals(other$rejectedExecutionHandler)) {
                return false;
            }
            ThreadFactory this$threadFactory = this.getThreadFactory();
            ThreadFactory other$threadFactory = other.getThreadFactory();
            if (this$threadFactory == null ? other$threadFactory != null : !this$threadFactory.equals(other$threadFactory)) {
                return false;
            }
            String this$threadPoolId = this.getThreadPoolId();
            String other$threadPoolId = other.getThreadPoolId();
            if (this$threadPoolId == null ? other$threadPoolId != null : !this$threadPoolId.equals(other$threadPoolId)) {
                return false;
            }
            TaskDecorator this$taskDecorator = this.getTaskDecorator();
            TaskDecorator other$taskDecorator = other.getTaskDecorator();
            if (this$taskDecorator == null ? other$taskDecorator != null : !this$taskDecorator.equals(other$taskDecorator)) {
                return false;
            }
            Long this$awaitTerminationMillis = this.getAwaitTerminationMillis();
            Long other$awaitTerminationMillis = other.getAwaitTerminationMillis();
            if (this$awaitTerminationMillis == null ? other$awaitTerminationMillis != null : !((Object)this$awaitTerminationMillis).equals(other$awaitTerminationMillis)) {
                return false;
            }
            Boolean this$waitForTasksToCompleteOnShutdown = this.getWaitForTasksToCompleteOnShutdown();
            Boolean other$waitForTasksToCompleteOnShutdown = other.getWaitForTasksToCompleteOnShutdown();
            if (this$waitForTasksToCompleteOnShutdown == null ? other$waitForTasksToCompleteOnShutdown != null : !((Object)this$waitForTasksToCompleteOnShutdown).equals(other$waitForTasksToCompleteOnShutdown)) {
                return false;
            }
            Boolean this$allowCoreThreadTimeOut = this.getAllowCoreThreadTimeOut();
            Boolean other$allowCoreThreadTimeOut = other.getAllowCoreThreadTimeOut();
            return !(this$allowCoreThreadTimeOut == null ? other$allowCoreThreadTimeOut != null : !((Object)this$allowCoreThreadTimeOut).equals(other$allowCoreThreadTimeOut));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadPoolInitParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $corePoolNum = this.getCorePoolNum();
            result = result * 59 + ($corePoolNum == null ? 43 : ((Object)$corePoolNum).hashCode());
            Integer $maxPoolNum = this.getMaxPoolNum();
            result = result * 59 + ($maxPoolNum == null ? 43 : ((Object)$maxPoolNum).hashCode());
            Long $keepAliveTime = this.getKeepAliveTime();
            result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
            TimeUnit $timeUnit = this.getTimeUnit();
            result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
            Long $executeTimeOut = this.getExecuteTimeOut();
            result = result * 59 + ($executeTimeOut == null ? 43 : ((Object)$executeTimeOut).hashCode());
            Integer $capacity = this.getCapacity();
            result = result * 59 + ($capacity == null ? 43 : ((Object)$capacity).hashCode());
            BlockingQueue<Runnable> $workQueue = this.getWorkQueue();
            result = result * 59 + ($workQueue == null ? 43 : $workQueue.hashCode());
            RejectedExecutionHandler $rejectedExecutionHandler = this.getRejectedExecutionHandler();
            result = result * 59 + ($rejectedExecutionHandler == null ? 43 : $rejectedExecutionHandler.hashCode());
            ThreadFactory $threadFactory = this.getThreadFactory();
            result = result * 59 + ($threadFactory == null ? 43 : $threadFactory.hashCode());
            String $threadPoolId = this.getThreadPoolId();
            result = result * 59 + ($threadPoolId == null ? 43 : $threadPoolId.hashCode());
            TaskDecorator $taskDecorator = this.getTaskDecorator();
            result = result * 59 + ($taskDecorator == null ? 43 : $taskDecorator.hashCode());
            Long $awaitTerminationMillis = this.getAwaitTerminationMillis();
            result = result * 59 + ($awaitTerminationMillis == null ? 43 : ((Object)$awaitTerminationMillis).hashCode());
            Boolean $waitForTasksToCompleteOnShutdown = this.getWaitForTasksToCompleteOnShutdown();
            result = result * 59 + ($waitForTasksToCompleteOnShutdown == null ? 43 : ((Object)$waitForTasksToCompleteOnShutdown).hashCode());
            Boolean $allowCoreThreadTimeOut = this.getAllowCoreThreadTimeOut();
            result = result * 59 + ($allowCoreThreadTimeOut == null ? 43 : ((Object)$allowCoreThreadTimeOut).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractBuildThreadPoolTemplate.ThreadPoolInitParam(corePoolNum=" + this.getCorePoolNum() + ", maxPoolNum=" + this.getMaxPoolNum() + ", keepAliveTime=" + this.getKeepAliveTime() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ", executeTimeOut=" + this.getExecuteTimeOut() + ", capacity=" + this.getCapacity() + ", workQueue=" + this.getWorkQueue() + ", rejectedExecutionHandler=" + this.getRejectedExecutionHandler() + ", threadFactory=" + this.getThreadFactory() + ", threadPoolId=" + this.getThreadPoolId() + ", taskDecorator=" + this.getTaskDecorator() + ", awaitTerminationMillis=" + this.getAwaitTerminationMillis() + ", waitForTasksToCompleteOnShutdown=" + this.getWaitForTasksToCompleteOnShutdown() + ", allowCoreThreadTimeOut=" + this.getAllowCoreThreadTimeOut() + ")";
        }
    }
}

