/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.matcher;

import cn.hutool.cron.pattern.Part;
import cn.hutool.cron.pattern.matcher.AlwaysTrueMatcher;
import cn.hutool.cron.pattern.matcher.BoolArrayMatcher;
import cn.hutool.cron.pattern.matcher.DayOfMonthMatcher;
import cn.hutool.cron.pattern.matcher.PartMatcher;
import java.time.Year;
import java.util.Calendar;
import java.util.TimeZone;

public class PatternMatcher {
    private final PartMatcher[] matchers;

    public PatternMatcher(PartMatcher secondMatcher, PartMatcher minuteMatcher, PartMatcher hourMatcher, PartMatcher dayOfMonthMatcher, PartMatcher monthMatcher, PartMatcher dayOfWeekMatcher, PartMatcher yearMatcher) {
        this.matchers = new PartMatcher[]{secondMatcher, minuteMatcher, hourMatcher, dayOfMonthMatcher, monthMatcher, dayOfWeekMatcher, yearMatcher};
    }

    public PartMatcher get(Part part) {
        return this.matchers[part.ordinal()];
    }

    public boolean match(int second, int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year) {
        return (second < 0 || this.matchers[0].match(second)) && this.matchers[1].match(minute) && this.matchers[2].match(hour) && PatternMatcher.isMatchDayOfMonth(this.matchers[3], dayOfMonth, month, Year.isLeap(year)) && this.matchers[4].match(month) && this.matchers[5].match(dayOfWeek) && this.matchers[6].match(year);
    }

    private static boolean isMatchDayOfMonth(PartMatcher matcher, int dayOfMonth, int month, boolean isLeapYear) {
        return matcher instanceof DayOfMonthMatcher ? ((DayOfMonthMatcher)matcher).match(dayOfMonth, month, isLeapYear) : matcher.match(dayOfMonth);
    }

    public Calendar nextMatchAfter(int[] values, TimeZone zone) {
        int i;
        Calendar calendar = Calendar.getInstance(zone);
        int nextValue = 0;
        for (i = Part.YEAR.ordinal(); i >= 0; --i) {
            nextValue = this.matchers[i].nextAfter(values[i]);
            if (nextValue > values[i]) {
                this.setValue(calendar, Part.of(i), nextValue);
                --i;
                break;
            }
            if (nextValue < values[i]) {
                ++i;
                nextValue = -1;
                break;
            }
            this.setValue(calendar, Part.of(i), nextValue);
        }
        if (-1 == nextValue) {
            while (i <= Part.YEAR.ordinal()) {
                nextValue = this.matchers[i].nextAfter(values[i] + 1);
                if (nextValue > values[i]) {
                    this.setValue(calendar, Part.of(i), nextValue);
                    --i;
                    break;
                }
                ++i;
            }
        }
        this.setToMin(calendar, i);
        return calendar;
    }

    private Calendar setToMin(Calendar calendar, int toPart) {
        for (int i = 0; i <= toPart; ++i) {
            Part part = Part.of(i);
            this.setValue(calendar, part, this.getMin(part));
        }
        return calendar;
    }

    private int getMin(Part part) {
        int min;
        PartMatcher matcher = this.get(part);
        if (matcher instanceof AlwaysTrueMatcher) {
            min = part.getMin();
        } else if (matcher instanceof BoolArrayMatcher) {
            min = ((BoolArrayMatcher)matcher).getMinValue();
        } else {
            throw new IllegalArgumentException("Invalid matcher: " + matcher.getClass().getName());
        }
        return min;
    }

    private Calendar setValue(Calendar calendar, Part part, int value) {
        switch (part) {
            case MONTH: {
                --value;
                break;
            }
            case DAY_OF_WEEK: {
                ++value;
            }
        }
        calendar.set(part.getCalendarField(), value);
        return calendar;
    }
}

